#include <stdlib.h>
#include <string.h>
#include <conio.h>
#include <stdio.h>
#define READONLY        "r"
#define UPDATE          "r+"
#define FALSE            0
#define TRUE             1

typedef  int              boolean;

# define NAMESIZE         21
# define SUBJECTSIZE      11
# define TRAILER          9999
# define ABSOLUTE         0
# define PRIME            17

# define INSERT           'I'
# define DELETE           'D'
# define CHANGE           'C'
# define ERROR            -1
# define ABSENT            0
# define OCCUPIED         '*'
# define UNOCCUPIED       ' '
typedef  struct {
   int identification ;
   char name[NAMESIZE] ;
   char subject[SUBJECTSIZE] ;
   int  grade ;
} RECORD ;
typedef  struct {
                 char type ;
                 RECORD student ;
                } TRANSACTION ;
typedef  struct {
                  char occupied ;
                  RECORD student ;
                } MASTER ;

char *prog ;
boolean get_transaction_record(FILE *fp, TRANSACTION *transaction);
int read_master_record(FILE *fp, int relative_record_number, MASTER *master);
int write_master_record(FILE *fp,
	    int relative_record_number, MASTER *master);
int get_master_record(FILE *fp, int key, MASTER *master);
int put_master_record(FILE *fp, int key,MASTER *master);
int choose_next_key(int identification);
int address(int key);
void  apply_transaction(boolean *allocated,
      TRANSACTION *transaction, MASTER *master);
int  do_initial_status(int current_key,
    boolean *allocated, FILE *fp, MASTER *master);
void   do_final_status(FILE *fp, int relative_record_number,
	       boolean allocated, MASTER *master);
void  copy_corresponding(RECORD *destination, RECORD *source);
void  syserr (int errcode, char *message, char *argument);
void  error (char code, char *message, int id);
void  main(int argc, char *argv[])
 {
   FILE     *fpmas,*fptrans ;
   int      current_key ,
            relative_record_number ;
   boolean     allocated;
   TRANSACTION transaction;
   MASTER      master ;
   clrscr();
   prog = argv[0];
   if(argc != 3)
     syserr(1, "usage: %s file1 file2 ", prog);
   else if((fptrans=fopen (argv[1], READONLY)) == NULL)
     syserr(2, "cannot open %s\n", argv[1]);
   else if((fpmas=fopen (argv[2], UPDATE)) == NULL)
    syserr(2, "cannot open %s\n", argv[2]);
   else
   {
    get_transaction_record(fptrans, &transaction) ;
    current_key = choose_next_key(transaction.student.identification);
    while(current_key != TRAILER)
    {
     relative_record_number = do_initial_status(
		       current_key,&allocated, fpmas,&master);
     while(current_key == transaction.student.identification)
     {
	 apply_transaction (&allocated, &transaction,&master) ;
	 get_transaction_record(fptrans, &transaction);
     }
     do_final_status (fpmas, relative_record_number, allocated, &master);
     current_key = choose_next_key(transaction.student.identification);
    } //end of while
    fcloseall();
   } //end of else
}
//**************************
boolean get_transaction_record(FILE *fp, TRANSACTION *transaction)
{
    if (fscanf (fp, "%4d%c%20s%10s%2d",
	&transaction -> student.identification,
	    &transaction -> type,
	    transaction -> student.name,
	    transaction -> student.subject,
	    &transaction -> student.grade) == 5)
       return(TRUE);
    return(FALSE);

}
//********************
int read_master_record(FILE *fp,
	    int relative_record_number, MASTER *master)
{
   if(fseek(fp, (long) relative_record_number
	       *sizeof(MASTER), SEEK_SET) !=0 )
      return(ERROR) ;
   else if(fread((char *)master, sizeof(MASTER), 1, fp) != 1)
      return(ERROR) ;
   else
      return(relative_record_number) ;
}
//****************************
int write_master_record(FILE *fp,
	    int relative_record_number, MASTER *master)
{
    if(fseek(fp, (long) relative_record_number
	    *sizeof(MASTER), ABSOLUTE) != 0)
       return(ERROR) ;
    else if(fwrite((char *) master, sizeof(MASTER), 1, fp) != 1)
       return(ERROR);
    else
      return(relative_record_number) ;
}
//**********************
int get_master_record(FILE *fp, int key, MASTER *master)
  {
   int k, relative_record_number ;
   relative_record_number = address(key) ;
   for(k = 0 ; k < PRIME ; k++)
   if(read_master_record(fp,
   relative_record_number,master) == ERROR)
     return(ERROR) ;
   else if(master -> occupied == UNOCCUPIED)
      return(ABSENT) ;
   else if(key== master->student.identification)
      return(relative_record_number) ;
   else
     relative_record_number= relative_record_number==PRIME ?
		    1 : relative_record_number+1 ;
    return(ABSENT);
  }
//************************
int put_master_record(FILE *fp, int key,MASTER *master)
    {
     int k , relative_record_number ;
     MASTER  temp_master ;
     relative_record_number=address(key);
     for(k=0 ; k<PRIME ; k++)
      if(read_master_record(fp,
       relative_record_number,
       &temp_master)==ERROR)return(ERROR);
      else if
       (temp_master.occupied==UNOCCUPIED)
        return(write_master_record(fp,
       relative_record_number,master));
      else if(key==
       temp_master.student.identification)
          return(write_master_record(fp,
         relative_record_number,master));
       else
        relative_record_number=
        relative_record_number==PRIME ? 1
             : relative_record_number+1 ;
       syserr(20,
       "overflow in:%s\n","masterfile") ;
       return 0;
     }
//**********************
int choose_next_key(int identification)
{
       return(identification) ;
}
//****************
int address(int key)
{
      return(key % PRIME + 1);
}
//*********************
void  apply_transaction(boolean *allocated,
      TRANSACTION *transaction, MASTER *master)
{
    switch(transaction -> type)
    {
     case  INSERT:
      if(*allocated==TRUE)
       error(INSERT,
       "record already exists\n",
       transaction->
         student.identification);
      else
        {
         copy_corresponding(
         &master -> student,
         &transaction -> student);
         *allocated=TRUE;
        }
        break;
     case   DELETE:
       if(*allocated==FALSE)
         error(DELETE,
         "record dose not exist\n",
        transaction->
          student.identification);
        else
          *allocated=FALSE;
        break;
      case  CHANGE:
       if(*allocated==FALSE)
         error(CHANGE,
         "record dose not exist\n",
       transaction->
       student.identification);
       else
        copy_corresponding(
          &master -> student,
        &transaction -> student) ;
       break;
     }
   }
//********************
int  do_initial_status(int current_key,
    boolean *allocated, FILE *fp, MASTER *master)
    {
      int relative_record_number ;
      *allocated = FALSE;
      relative_record_number=
	get_master_record(fp, current_key, master) ;
      if(relative_record_number != ABSENT)
	  *allocated=TRUE;
      return(relative_record_number);
    }
//*********************
void   do_final_status(FILE *fp, int relative_record_number,
	       boolean allocated, MASTER *master)
    {
  //   int record_number=0 ;
     if(allocated==TRUE)
     {
     if(relative_record_number != ABSENT)
     {
      master -> occupied=OCCUPIED ;
      if(write_master_record(fp,
      relative_record_number,
        master)==ERROR)
        syserr(21,"error writing %s\n",
        "master record") ;
      }
      else
      {
       master -> occupied=OCCUPIED ;
       put_master_record(fp,
       master -> student.identification,
       master) ;
       }
      }
     else
     {
      master -> occupied=UNOCCUPIED ;
      if(write_master_record(fp,
      relative_record_number,
      master)==ERROR)
      syserr(22,
      "error writing %s","master record");
      }
     }
//*********************
void  copy_corresponding(RECORD *destination, RECORD *source)
{
     destination ->identification=
     source -> identification;
     strcpy(destination -> name,
       source -> name);
     strcpy(destination -> subject,
     source -> subject);
     destination ->grade=source -> grade;

    }
 //********************
void  syserr (int errcode, char *message, char *argument)
    {
     fprintf(stderr,"%s[%2d]:",prog,
     errcode);
     fprintf(stderr,message,argument);
     exit(errcode);
    }
//**********************
void  error (char code, char *message, int id)
    {
      printf("%c    %30s   %4d\n",code,
        message,id);
    }


















