#include <string.h>
#include <dos.h>
#include <ctype.h>
#include <bios.h>
#include <stdlib.h>
#include <stdio.h>
#define  BORDER      1
#define  ESC        27
#define  REV_VID  0x70
#define  NORM_VID    2
#define  MAX_FRAME  10
int make_menu(int num, char *menu[], char *keys,
		 int count, int x, int y, int border);
void  goto_xy(int, int);
int   pulldown(int num);
void  restore_video(int num);
void  save_video(int num);
int   video_mode();
void  drow_border(int num);
void  display_menu(int num);
int   get_resp(int num);
void  write_string(int x, int y, char *p, int attrib);
void  write_char(int x, int y, char ch, int attrib);
void  pd_driver() ,cls() ;
int   is_in(char *s , char c);
char far *vid_mem ;
struct menu_frame {
       int startx,endx,starty,endy ;
       unsigned char *p ;
       char **menu ;
       char *keys ;
       int border,count ;
       int active ;
} frame[MAX_FRAME], i ;

char *fruit[]={
		"apple     ",
		"orange    ",
		"pear      ",
		"grape     ",
		"raspberry ",
		"strawberry" } ;
char *color []={
	       "red",
	       "yellow",
	       "orange",
	       "green",} ;
char *apple_type[]={
	       "red delicious" ,
	       "jonthan",
	       "winesap",
	       "rome"};
char *grape_type[]= {
	       "Concord " ,
	       "cAnadice " ,
	       "Thompson" ,
	       "Red flame" } ;
int main()
 {
       int i ;
       cls() ;
       goto_xy(0, 0);
       make_menu(0,fruit,"aopgrs",6,5,20,BORDER) ;
       make_menu(1,color , "ryog",4,9,28,BORDER) ;
       make_menu(2,apple_type,"rjwr",4,12,32,BORDER) ;
       make_menu(3,grape_type,"catr",4,9,10,BORDER) ;
       printf("\n select your fruit:") ;
       pd_driver() ;/* active the menu system */
       return 0;
  }
//************************
void pd_driver()
 {
   int choice1,choice2,selection ;
   /* active as need */
   while((choice1 = pulldown(0)) != -1)  {
     switch(choice1) {
       case 0 : /* want an apple */
	  while((choice2 = pulldown(1)) != -1)  {
	    if(choice2 == 0)  selection=pulldown(2) ; /* rea */
		restore_video(2) ;
	  }//end of while
	  restore_video(1) ;
	  break ;
       case 1 :
       case 2 :
	  goto_xy(1, 0);
	  printf("\n out of that seection ") ;
	  break ;
       case 3: /* want a grape */
	  selection=pulldown(3) ;
	  restore_video(3) ;
	  break ;
       case 4 :
       case 5 :
	  goto_xy(1,0) ;
	  printf("\n out of that selection ") ;
	  break ;
     }//end of switch
   }//end of while
   restore_video(0) ;
 }
//************************
int pulldown(int num)
/* display pulldown menu and return selection*/
  {
       int vmode, choice ;
       vmode = video_mode() ;
       if((vmode != 2) && (vmode != 3) && (vmode != 7))
       {
	 printf("\n video must be in 80 column text.");
	 exit(1) ;
       }
       if(vmode==7)
	   vid_mem=(char far  *) 0xB0000000;
       else
	   vid_mem=(char far  *) 0xB8000000;
       /* get active window */
       if(!frame[num].active) /* not currently in use */
       {
	 save_video(num) ; /* save the current screen */
	 frame[num].active = 1 ; /* set active flag */
       }
       if(frame[num].border) drow_border(num) ;
       display_menu(num) ;
       return get_resp(num) ;
  }
//****************
int make_menu(int num, char *menu[], char *keys,
		 int count, int x, int y, int border)
  {
     register int i , len ;
     int endx , endy , choice , vmode ;
     unsigned char *p ;
     if(num > MAX_FRAME) {
	   printf("\n too many menus.") ;
	   return 0 ;
      }
      if((x > 24) || (x < 0) || (y > 79) || (y < 0)) {
	   printf("range error") ;
	   return 0 ;
      }
      len=0 ;
      for(i = 0 ; i < count ;i++)
	 if(strlen(menu[i]) > len) len=strlen(menu[i]) ;
      endy=len+2+y ;
      endx=count+1+x ;
      if((endx + 1 > 24) || (endy + 1 > 79)) {
	  printf("menu won't fit") ;
	  return 0 ;
      }
      p = (unsigned char *) malloc(2*(endx-x+1)*(endy-y+1)) ;
      if(!p)  exit(1) ;
      frame[num].startx = x ;
      frame[num].endx = endx ;
      frame[num].starty = y ;
      frame[num].endy = endy ;
      frame[num].p = p ;
      frame[num].menu = (char * *)menu ;
      frame[num].border = border ;
      frame[num].keys = keys ;
      frame[num].count = count ;
      frame[num].active = 0 ;
      return 1 ;
  }
//*********************
void display_menu(int num)
     {
       register int i,x ;
       char **m ;
       x = frame[num].startx+1 ;
       m = frame[num].menu ;
       for(i = 0 ; i < frame[num].count ; i++ , x++)
	  write_string(x ,frame[num].starty+1 , m[i] , NORM_VID) ;
     }
//******************
void drow_border(int num)
     {
      register int i ;
      char far *v , far *t ;
      v = vid_mem ;
      t = v ;
      for(i = frame[num].startx+1 ; i < frame[num].endx; i++)
      {
	v += (i * 160) + frame[num].starty * 2 ;
	*v++ = 179 ;
	*v = NORM_VID ;
	v = t ;
	v += (i*160)+frame[num].endy*2 ;
	*v++ = 179 ;
	*v = NORM_VID ;
	v = t ;
       }
      for(i = frame[num].starty + 1 ; i < frame[num].endy; i++)
      {
	v += (frame[num].startx*160) + i * 2 ;
	*v++ = 196 ;
	*v = NORM_VID ;
	v = t ;
	v += (frame[num].endx * 160) + i * 2 ;
	*v++ = 196 ;
	*v = NORM_VID ;
	v = t ;
       }
      write_char(frame[num].startx , frame[num].starty , 218 , NORM_VID) ;
      write_char(frame[num].startx , frame[num].endy , 191, NORM_VID) ;
      write_char(frame[num].endx , frame[num].starty , 192 , NORM_VID) ;
      write_char(frame[num].endx , frame[num].endy , 217 , NORM_VID) ;
     }
//**********************
int get_resp(int num)
  {
       union inkey {
	     char ch[2] ;
	     int i ;
       } c ;
       int arrow_choice = 0 , key_choice ;
       int x, y ;
       x = frame[num].startx + 1 ;
       y = frame[num].starty + 1 ;
      /*highligth the first selection*/
       goto_xy(x, y) ;
       write_string(x, y, frame[num].menu[0], REV_VID) ;
       for(;;)
       {
	 while(!bioskey(1));  /* wait for key stroke*/
	      c.i=bioskey(0) ; /* read the key */
	 goto_xy(x + arrow_choice, y) ;
	 write_string(x+arrow_choice,y,frame[num].menu[arrow_choice],NORM_VID);
	 if(c.ch[0])
	 {
	   key_choice = is_in(frame[num].keys,tolower(c.ch[0])) ;
	   if(key_choice)
	      return key_choice - 1 ;
	   switch(c.ch[0])  /*check for Enter or space key */
	   {
	     case '\r' : return arrow_choice ;
	     case ' '  : arrow_choice++ ;
		break ;
	     case ESC  : return -1 ;
	   }
	 } //end of if
	 else  {
	      switch(c.ch[1])
	      {
		case 72 : arrow_choice -- ;
		   break ;
		case 80 : arrow_choice ++ ;
		   break ;
	      }//end of switch
	 }//end of else
	 if(arrow_choice==frame[num].count)
	       arrow_choice = 0 ;
	 if(arrow_choice < 0)
	       arrow_choice = frame[num].count - 1 ;
	 goto_xy(x + arrow_choice, y) ;
	 write_string(x+arrow_choice,y,frame[num].menu[arrow_choice],REV_VID);
       }//end of for(;;)
  }
/********************/
void write_string(int x, int y, char *p, int attrib)
  {
       register int i ;
       char far *v;
       v = vid_mem ;
       v += (x * 160) + y * 2 ;
       for (i = y ; *p; i++) {
	   *v++ = *p++ ;
	   *v++ = attrib ;
       }//end of for
  }
/*********************/
void write_char(int x, int y, char ch, int attrib)
  {
       register int i ;
       char far *v ;
       v = vid_mem ;
       v += (x * 160) + y * 2 ;
       *v++ = ch ;
       *v = attrib ;
  }
/*****************/
void save_video(int num)
 {
       register int i , j ;
       char far *buf_ptr, far *v , far *t ;
       buf_ptr = frame[num].p ;
       v = vid_mem ;
       for(i = frame[num].starty ; i < frame[num].endy + 1; i++)
	 for(j = frame[num].startx; j < frame[num].endx + 1; j++)
	 {
	   t = v + (j * 160) + i * 2 ;
	   *buf_ptr++ = *t++ ;
	   *buf_ptr++ = *t ;
	   *(t - 1) = ' ' ;
	 }
  }
/************************/
void restore_video(int num)
     {
       register int i , j ;
       char far *v , far *t , far *buf_ptr ;
       buf_ptr = frame[num].p ;
       v = vid_mem ;
       t = v ;
       for(i = frame[num].starty ; i < frame[num].endy + 1; i++)
	 for(j = frame[num].startx; j < frame[num].endx+1;j++)
	 {
	   v = t ;
	   v += (j * 160) + i * 2 ;
	   *v++ = *buf_ptr++ ;
	   *v = *buf_ptr++ ;
	 }
	frame[num].active=0 ; /* deactivate */
 }
/*****************/
void cls()
    {
     union REGS r ;
     r.h.ah = 6 ;
     r.h.al = 0 ;
     r.h.ch = 0 ;
     r.h.cl = 0 ;
     r.h.dh = 24 ;
     r.h.dl = 79 ;
     r.h.bh = 7 ;
     int86(0x10, &r, &r) ;
   }
/********************/
void goto_xy(int x, int y)
    {
      union  REGS r ;
      r.h.ah = 2 ;
      r.h.dl = y ; /* column */
      r.h.dh = x ;
      r.h.bh = 0 ;
      int86(0x10, &r, &r) ;
  }
//***********************
int is_in(char *s , char c)
  {
     register int i ;
     for(i = 0 ; *s ; i++)
	if(*s++ == c)
	   return i + 1 ;
     return 0 ;
 }
//*************
int video_mode()
 {
       union REGS  r ;
       r.h.ah = 15 ;
       return int86(0x10, &r, &r) & 255 ;
  }

