#include <stdio.h>
#include <dos.h>
#include <bios.h>
#include <stdlib.h>
#include <ctype.h>
#include <conio.h>
#include <string.h>

#define  BORDER       1
#define  ESC         27
#define  REV_VID   0x70
#define  NORM_VID     7
int popup(char *menu[] , char *keys , int count ,int x, int y, int border);
void save_video(int startx, int endx, int starty,
		 int endy , unsigned int *buf_ptr);
void draw_border(int startx, int starty, int endx, int endy);
void display_menu(char *menu[], int x, int y, int count);
int get_resp(int x, int y, int count, char *menu[] , char *keys);
void restore_video(int startx, int endx, int starty,
		   int endy, unsigned char *buf_ptr);
int is_in(char *s , char c);
void write_video(int x, int y, char *p, int attrib);
void goto_xy(int , int) , cls() ;

char *fruit[] = {
		"apple     ",
		"orange    ",
		"pear      ",
		"grape     ",
		"raspberry ",
		"strawberry" } ;
char *color [] = {
	       "red",
	       "yellow",
	       "orange",
	       "green" } ;
char *apple_type[] = {
	       "red delicious" ,
	       "jonthan",
	       "winesap",
	       "rome"};
int main()
 {
       int i ;
       cls() ;
       goto_xy(0, 0) ;
       popup(fruit," aoprts", 6, 1, 3, BORDER) ;
       popup(color , "ryog", 4, 5, 10, BORDER) ;
       popup(apple_type, "rjw", 4, 10, 18, BORDER) ;
       getch();
       return 0;
  }
/* displ a pop-up menu and return
 selection
 return -2 if menu cannot be constructed
 return -1 if user hits escape key
 otherwise the item number is returned
 starting with 0 as the first(top most)
 entry
*/

int popup(char *menu[] , char *keys , int count ,int x, int y, int border)
/* displ a pop-up menu and return
 selection
 return -2 if menu cannot be constructed
 return -1 if user hits escape key
 otherwise the item number is returned
 starting with 0 as the first(top most)
 entry
*/
 {
	 register int i , len ;
	 int endx , endy , choice  ;
	 unsigned int *p ;
	 if((x > 24) || (x < 0) || (y > 79) || (y < 0))	 {
	     printf("\n range error") ;
	     return -2 ;
	 }
	 len = 0 ;
	 for(i = 0 ; i < count ; i++)
	    if(strlen(menu[i]) > len)
		 len = strlen(menu[i]) ;
	 endy = len+2+y ;
	 endx = count + 1 + x ;
	 if((endx + 1 > 24) || (endy + 1 > 79))	 {
	     printf("\n menu won't fit") ;
	     return -2 ;
	 }
	 p = (unsigned int *) malloc((endx - x + 1) * (endy - y + 1)) ;
	 if(!p)
	    exit(1) ;
	 save_video(x, endx + 1, y, endy + 1, p);
	 if(border)
	     draw_border(x, y, endx, endy) ;
	 display_menu(menu , x + 1 , y + 1 , count) ;
	 choice = get_resp(x + 1, y, count, menu , keys) ;
	 restore_video(x, endx + 1 , y , endy + 1 ,(char *) p) ;
	 free(p) ;
	 return choice ;
  }
//*****************
void display_menu(char *menu[], int x, int y, int count)
  {
       register int i ;
       for(i = 0 ; i < count ; i++ , x++)  {
	   goto_xy(x, y) ;
	   printf(menu[i]) ;
       }
  }
//*******************
void draw_border(int startx, int starty, int endx, int endy)
     {
      register int i ;
      for(i = startx + 1 ; i < endx; i++)  {
	   goto_xy(i, starty) ;
	   putchar(179) ;
	   goto_xy(i,endy) ;
	   putchar(179) ;
      }
      for(i = starty + 1 ; i < endy; i++)  {
	goto_xy(startx, i) ;
	putchar(196) ;
	goto_xy(endx, i) ;
	putchar(196) ;
      }
      goto_xy(startx, starty) ;
      putchar(218) ;
      goto_xy(startx, endy) ;
      putchar(191) ;
      goto_xy(endx, starty) ;
      putchar(192) ;
      goto_xy(endx, endy) ;
      putchar(217) ;
 }
//***********************
int get_resp(int x, int y, int count, char *menu[] , char *keys)
  {
     union inkey {
		     char ch[2] ;
		     int i ;
		 } c ;
     int arrow_choice = 0 , key_choice ;
     y++ ;
     goto_xy(x,y) ;
     write_video(x, y, menu[0], REV_VID) ;
     for(;;)  {
	while(!bioskey(1));
	c.i = bioskey(0) ;
	goto_xy(x + arrow_choice, y) ;
	write_video(x + arrow_choice, y, menu[arrow_choice], NORM_VID);
	if(c.ch[0]) { /* normal key */
	    key_choice = is_in(keys, tolower(c.ch[0])) ;
	    if(key_choice)
		 return key_choice - 1 ;
	    switch(c.ch[0])  {
		case '\r' : return arrow_choice ;
		case ' '  : arrow_choice++ ;  break ;
		case ESC  : return -1 ; /* cancel */
	     }//end of switch
	}//end of if
	else {
	      switch(c.ch[1]) {
		case 72 : arrow_choice -- ;
		   break ;
		case 80 : arrow_choice ++ ;
		   break ;
	      }//end of switch
	} // end of else
	if(arrow_choice == count)
	       arrow_choice = 0 ;
	if(arrow_choice < 0)
	       arrow_choice = count - 1 ;
	goto_xy(x+arrow_choice,y) ;
	write_video(x+arrow_choice,y,menu[arrow_choice],REV_VID);
     }//end of for(;;)
 }
//************************
void write_video(int x, int y, char *p, int attrib)
  {
       register int i,j ;
       union REGS r ;
       for(i = y ; *p ; i++)   {
	    goto_xy(x,i) ;
	    r.h.ah=9 ;
	    r.h.bh=0 ;
	    r.x.cx=1 ;
	    r.h.al=*p++ ;
	    r.h.bl=attrib ;
	    int86(0x10,&r,&r) ;
       }
 }
//**************************
void save_video(int startx, int endx, int starty,
		 int endy , unsigned int *buf_ptr)
 {
       register int i , j ;
       union REGS r ;
       for(i = starty ; i < endy; i++)
	 for(j = startx; j < endx; j++) {
	   goto_xy(j, i) ;
	   r.h.ah = 8 ;
	   r.h.bh = 0 ;
	   *buf_ptr++ = int86(0x10, &r, &r) ;
	   putchar(' ') ;
	 }
 }
//********************
void restore_video(int startx, int endx, int starty,
		   int endy, unsigned char *buf_ptr)
  {
       register int i , j ;
       union REGS r ;
       for(i = starty ; i < endy; i++)
	 for(j = startx; j < endx; j++) {
	      goto_xy(j, i) ;
	      r.h.ah = 9 ;
	      r.h.bh = 0 ;
	      r.x.cx = 1 ;
	      r.h.al = *buf_ptr++ ;
	      r.h.bl = *buf_ptr++ ;
	      int86(0x10, &r, &r) ;
	 }
  }
//**************************
void cls()
 {
     union REGS r ;
     r.h.ah = 6 ;
     r.h.al = 0 ;
     r.h.ch = 0 ;
     r.h.cl = 0 ;
     r.h.dh = 24 ;
     r.h.dl = 79 ;
     r.h.bh = 7 ;
     int86(0x10, &r, &r) ;
 }
//*******************************
void goto_xy(int x, int y)
  {
      union  REGS r ;
      r.h.ah = 2 ;
      r.h.dl = y ; /* column */
      r.h.dh = x ;
      r.h.bh = 0 ;
      int86(0x10, &r, &r) ;
  }
//**********************
int is_in(char *s , char c)
  {
     register int i ;
     for(i = 0 ; *s ; i++)
	if(*s++ == c)
	   return i + 1 ;
     return 0 ;
  }












