#include <dos.h>
#include <ctype.h>
#include <math.h>
#include <bios.h>
#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#define NUM_SIDES 20
void mode(int mode);
void palette(int pnum);
void line(int startx, int starty, int endx, int endy, int color);
void mempoint(int x , int y ,int color);
void rotate_point(double theta, double *x, double *y,
		  int x_org, int y_org);
void rotate_object(double ob[][4], double theta, int x, int y, int sides);
void display_object(double ob[][4], int sides);
void box(int startx, int starty, int endx, int endy, int color);
void fill_box(int startx, int starty, int endx, int endy, int color);
void circle(int x_center, int y_center, int radius, int color);
void plot_circle(int x, int y, int x_center, int y_center, int color);
void fill_circle(int x , int y , int r , int c);
void save_pic();
void load_pic();
void copy(int startx, int starty, int endx, int endy, int x, int y);
void move(int startx, int starty, int endx, int endy, int x, int y);
void xhairs(int x, int y, int c);
unsigned char read_point(int x, int y);
void goto_xy(int x, int y);
int define_object(double ob[][4], int x, int y);

double object [NUM_SIDES][4] ;
double asp_ratio ;

int main ()
 {
      union k {
		char c[2] ;
		int i ;
	      } key ;
      int x = 10 , y = 10, cc = 2, i ;
      int on_flag = 1, pal_num = 1 ;
      int startx = 0, starty = 0, endx = 0, endy = 0 ;
      int first_point = 1 , inc = 1 , sides = 0 ;
      mode(4) ;
      palette(0) ;
      xhairs(x, y, 1) ;
      do {
	  key.i = bioskey(0) ;
	  if(!key.c[0])
	    switch(key.c[1])
	    {
	       case 75 :
		  if(on_flag)
		    line(x, y, x, y - inc, cc) ;
		  y -= inc ;
		  break ;
	       case 77 :
		  if(on_flag)
		    line(x, y, x, y + inc, cc) ;
		  y += inc ;
		  break ;
	       case 72 :
		  if(on_flag)
		    line(x, y, x - inc, y, cc) ;
		  x -= inc ;
		  break ;
	       case 80 :
		  if(on_flag)
		    line(x, y,x + inc, y, cc) ;
		  x += inc ;
		  break ;
	       case 71 :
		  if(on_flag)
		    line(x, y, x - inc, y - inc, cc) ;
		  x -= inc ;
		  y -= inc ;
		  break ;
	       case 73 :
		  if(on_flag)
		    line(x, y, x - inc, y + inc, cc) ;
		  x -= inc ;
		  y += inc ;
		  break ;
	       case 79 :
		  if(on_flag)
		    line(x, y, x + inc, y - inc, cc) ;
		  x += inc ;
		  y -= inc ;
		  break ;
	       case 81 :
		  if(on_flag)
		    line(x, y, x + inc, y + inc, cc) ;
		  x += inc ;
		  y += inc ;
		  break ;
	       case 59 :
		  inc = 1 ;
		  break ;
	       case 60 :
		  inc = 5 ;
		  break ;
	    }
	    else switch(tolower(key.c[0]))
		 {
		   case 'o' : on_flag = !on_flag ;
		     break ;
		   case '1' : cc = 1 ;
		     break ;
		   case '2' : cc = 2 ;
		     break ;
		   case '3' : cc = 3 ;
		     break ;
		   case '0' : cc = 0 ;
		     break ;
		   case 'b' : box(startx, starty, endx, endy, cc) ;
		     break ;
		   case 'f' : fill_box(startx, starty, endx, endy, cc) ;
		     break ;
		   case 'l' :line(startx, starty, endx, endy, cc) ;
		     break ;
		   case 'c' : circle(startx, starty, endy - starty, cc) ;
		     break ;
		   case 's' : save_pic() ;
		     break ;
		   case 'r' : load_pic() ;
		     break ;
		   case 'm' : move(startx, starty, endx, endy, x, y) ;
		     break ;
		   case 'x' : copy(startx, starty, endx, endy, x, y) ;
		     break ;
		   case 'd' : sides = define_object(object, x, y) ;
		     break ;
		   case 'a' :rotate_object(object, 0.05, x, y, sides) ;
		     break ;
		   case '\r' :
		     if(first_point) {
			  startx = x ;
			  starty = y ;
		     } //end of if
		     else  {
			  endx = x ;
			  endy = y ;
		     }//end of else
		     first_point = !first_point ;
		     break ;
		   case 'p': pal_num = pal_num == 1 ? 2 : 1 ;
		      palette(pal_num) ;
		 } //end of switch
      } while(key.c[0] != 'q') ;
      getch() ;
      mode(2) ;
      return 0;
  } //end of main
//**********************
void mode(int mode_code)
   {
       union REGS r ;
       r.h.al = mode_code ;
       r.h.ah = 0 ;
       int86(0x10, &r, &r) ;
    }
//*************************
void palette(int pnum)
   {
       union REGS r ;
       r.h.bh = 1 ;
       r.h.bl = pnum ;
       r.h.ah = 0xB ;
       int86(0x10, &r, &r) ;
   }
//********************
void mempoint(int x , int y , int color)
  {
      union mask {
	  char c[2] ;
	  int i ;
      } bit_mask ;
      int i , index , bitpos ;
      unsigned char t ;
      char xor ;
      char far *ptr = (char far *) 0xB8000000 ;
      bit_mask.i = 0xFF3F ; /* 11111111 00111111 */
      if(x < 0 || x > 199 || y < 0 || y > 319)
	 return ;
      xor = color & 128 ;
      color = color & 127 ;
      bitpos = y % 4 ;
      color <<= 2 * (3 - bitpos) ;
      bit_mask.i>>= 2 * bitpos ;
      index = x * 40 +( y / 4) ;
      if(x % 2)
	  index += 8152 ;
      if(!xor) {
	t = *(ptr + index) & bit_mask.c[0] ;
	*(ptr + index) = t | color ;
       }
      else  {
	   t = *(ptr + index) | (char) 0 ;
	   *(ptr + index) = t ^ color ;
      }
 }
//********************
void line(int startx, int starty, int endx, int endy, int color)
  {
       register int t , distance ;
       int xerr = 0 , yerr = 0 , deltax , deltay ;
       int incx , incy ;
       deltax = endx - startx ;
       deltay = endy - starty ;
       if(deltax > 0)
	  incx = 1 ;
       else if(deltax == 0)
	  incx = 0 ;
       else
	  incx =- 1 ;
       if(deltay > 0)
	  incy = 1 ;
       else if(deltay == 0)
	  incy = 0 ;
       else
	  incy =- 1 ;
       deltax = abs(deltax) ;
       deltay=abs(deltay) ;
       if(deltax > deltay)
	    distance = deltax ;
       else
	    distance = deltay ;
       for(t = 0 ; t < distance + 1 ; t++) {
	   mempoint(startx , starty , color) ;
	   xerr += deltax ;
	   yerr += deltay ;
	   if(xerr > distance) {
	       xerr-=distance ;
	       startx+=incx ;
	   }
	   if(yerr > distance) {
		yerr -= distance ;
		starty += incy ;
	   }
       }
 }
//****************************
void box(int startx, int starty, int endx, int endy, int color)
   {
       line(startx , starty , endx , starty , color) ;
       line(startx , starty , startx , endy , color) ;
       line(startx , endy , endx , endy , color) ;
       line(endx , starty , endx , endy , color) ;
   }
//***************************
void fill_box(int startx, int starty, int endx, int endy, int color)
   {
       register int i, begin, end ;
       begin = startx < endx ? startx : endx ;
       end = startx > endx ? startx : endx ;
       for(i = begin ; i < end ; i++)
	  line(i , starty , i , endy , color) ;
     }
//*******************
void circle(int x_center, int y_center, int radius, int color)
  {
     register int x , y , delta ;
     asp_ratio = 2.0 ;
     y = radius ;
     delta = 3- 2 * radius ;
     for(x = 0 ; x < y ; ) {
	plot_circle(x, y, x_center, y_center, color) ;
	if(delta < 0)
	  delta += 4 * x + 6 ;
	else {
	      delta += 4 * (x - y) + 10 ;
	      y -- ;
	}
	x++ ;
     }//end of for
     x = y ;
     if(y)
	plot_circle(x, y, x_center, y_center, color) ;
 }
//************************
void plot_circle(int x, int y, int x_center, int y_center, int color)
  {
       int startx , endx , endy , x1 , starty , y1 ;
       starty =y * asp_ratio ;
       endy = (y + 1) * asp_ratio ;
       startx = x * asp_ratio ;
       endx = (x + 1) * asp_ratio ;
       for(x1 = startx ; x1 < endx ; ++x1) {
	   mempoint(x1 + x_center, y + y_center, color) ;
	   mempoint(x1 + x_center, y_center - y, color) ;
	   mempoint(x_center - x1, y_center - y, color) ;
	   mempoint(x_center - x1 , y + y_center, color) ;
	}
	for(y1 = starty; y1 < endy ; ++y1) {
	    mempoint(y1 + x_center, x+y_center, color) ;
	    mempoint(y1 + x_center, y_center - x, color) ;
	    mempoint(x_center - y1, y_center - x, color) ;
	    mempoint(x_center - y1, x+y_center, color) ;
	}
 }
//******************************
void fill_circle(int x , int y , int r , int c)
  {
      while(r) {
	   circle(x,y,r,c) ;
	   r -- ;
      }
  }
//**************************
void save_pic()
 {
      char fname[80] ;
      FILE *fp ;
      register int i , j ;
      char far *ptr =( char far *)0xB8000000 ;
      char far *temp ;
      unsigned char buf[14][80] ;
      temp = ptr ;
      for(i = 0 ; i < 14 ; i++)
	 for(j = 0 ; j < 80 ; j += 2) {
	     buf[i][j]=*temp ;
	     buf[i][j+1]=*(temp+8152) ;
	     *temp = 0 ;
	     *(temp + 8152) = 0 ;
	     temp ++ ;
	 }
      gotoxy(0,0) ;
      printf("enter file nmae for put : ") ;
      gets(fname) ;
      fp = fopen(fname, "wb") ;
      if(fp == NULL) {
	 printf("cannot open file .press a key ...") ;
	 getch();
	 return ;
       }
      temp = ptr ;
      /* restore the top of current screen */
      for(i = 0 ; i < 14 ; i++)
	 for(j = 0 ; j < 80 ; j += 2) {
	   *temp = buf[i][j] ;
	   *(temp + 8152) = buf[i][j + 1] ;
	   temp ++ ;
	 }
      for(i=0 ; i < 8152 ; i++) {
	  putc(*ptr, fp) ; /* even byte */
	  putc(*(ptr + 8152), fp) ;
	  ptr++ ;
      }
      fclose(fp) ;
     }
//*********************
void load_pic()
 {
      char fname[80] ;
      FILE *fp ;
      register int i , j ;
      char far *ptr = (char far *) 0xB8000000 ;
      char far *temp ;
      unsigned char buf[14][80] ;
      temp = ptr ;
      for(i = 0 ; i < 14 ; i++)
	 for(j = 0 ; j < 80 ; j += 2) {
	   buf[i][j] =* temp ;
	   buf[i][j+1] =* (temp + 8152) ;
	   *temp = 0 ;
	   *(temp + 8152) = 0 ;
	   temp ++ ;
	 }
      gotoxy(0, 0) ;
      printf("enter file nmae for get : ") ;
      gets(fname) ;
      fp = fopen(fname,"rb") ;
      if(fp == NULL) {
	 printf("cannot open file .press a key ...") ;
	 temp = ptr ;
	 /* restore the top of current screen */
	 for(i=0 ; i < 14 ; i++)
	    for(j = 0 ; j < 80 ; j += 2) {
	       *temp = buf[i][j] ;
	       *(temp + 8152) = buf[i][j + 1] ;
	       temp ++ ;
	    }
	 return ;
       }//end of if
      /* load image from file */
      for(i =0  ; i < 8152 ; i++)  {
	 *ptr = getc(fp) ; /* even byte */
	 *(ptr + 8152) = getc(fp) ; /* odd byte */
	 ptr ++ ;
      }
      fclose(fp) ;
 }
//************************
void copy(int startx, int starty, int endx, int endy, int x, int y)
 {
      int i , j ;
      unsigned char c ;
      for(; startx <= endx ; startx ++ , x++)
	for(i = starty, j = y ; i < endy ; i++ , j++) {
	     c = read_point(startx, i) ;
	     mempoint(x, j, c) ;
	}
 }
//********************
void move(int startx, int starty, int endx, int endy, int x, int y)
 {
      int i , j ;
      unsigned char c ;
      for(; startx <= endx ; startx ++ , x++)
	for(i = starty, j = y ; i < endy ; i++ , j++) {
	     c = read_point(startx , i) ;
	  //   read_point(startx, i, 0) ;
	     mempoint(x, j, c) ;
	}
  }
//***********************
void xhairs(int x, int y, int c)
 {
       line(x-3, y, x + 3, y, c) ;
       line(x, y + 3, x, y - 3, c) ;
 }
//**************************
unsigned char read_point(int x, int y)
  {
      union mask {
	  char c[2] ;
	  int i ;
      } bit_mask ;
      int i, index, bitpos ;
      unsigned char t ;
      char xor ;
      char far *ptr = (char far *) 0xB8000000 ;
      bit_mask.i = 0xFF3F ; /* 11111111 00111111 */
      if(x < 0 || x > 199 || y < 0 || y > 319)
	 return -1;
      bitpos = y % 4 ;
      bit_mask.i <<= 2 * (3 - bitpos) ;
      bit_mask.i >>= 2 * bitpos ;
      index = x * 40 +( y >> 2) ;
      if(x % 2)
	  index += 8152 ;
       t = *(ptr + index) & bit_mask.c[0] ;
       t >>= 2 * (3 - bitpos) ;
       return t ;
 }
//**************************
void goto_xy(int x, int y)
  {
       union REGS r ;
       r.h.ah = 2 ;
       r.h.dl = y ;
       r.h.dh = x ;
       r.h.bh = 0 ;
       int86(0x10 , &r , &r) ;
  }
//*************************
void rotate_point(double theta, double *x, double *y,
		  int x_org, int y_org)
  {
       double tx, ty ;
       tx =* x - x_org ;
       ty =* y - y_org ;
       *x = tx * cos(theta) - ty * sin(theta) ;
       *y = tx * sin(theta) - ty * cos(theta) ;
       *x += x_org ;
       *y += y_org ;
  }
//***********************
void rotate_object(double ob[][4], double theta, int x, int y, int sides)
 {
       register int i , j ;
       double tempx , tempy ;
       char ch ;
       for(;;)  {
	  ch = getch() ;
	  switch(ch) {
	   case 'l' :
	       theta = theta < 0 ? -theta : theta ;
	       break ;
	   case 'r' :
	       theta = theta > 0 ? -theta : theta ;
	       break ;
	   default : return ;
	 }//end of switch
	 for(j = 0 ; j < sides ; j++)  {
	      line((int) ob[j][0] , (int)ob[j][1] ,
		 (int) ob[j][2] , (int)ob[j][3] , 0) ;
	      rotate_point(theta , &ob[j][2], &ob[j][3], x, y) ;
	      line((int) ob[j][0] , (int) ob[j][1] ,
		 (int) ob[j][2] , (int) ob[j][3] , 2) ;
	  }//end of for j =
       }//end of for (;;)
 }
//*******************************
void display_object(double ob[][4], int sides)
  {
       register int i ;
       for(i=0 ; i < sides ; i++)
	   line((int) ob[i][0] , (int)ob[i][1] ,
		(int) ob[i][2] , (int)ob[i][3] , 2) ;
   }
//**************************
int define_object(double ob[][4], int x, int y)
  {
       union k {
		char c[2] ;
		int i ;
       } key ;
       register int i , j ;
       char far *ptr = (char far *) 0xB8000000 ;
       char far *temp ;
       unsigned char buf[14][80] ;
       int sides = 0 ;
       temp = ptr ;
      for(i = 0 ; i < 14 ; i++)
	 for(j = 0 ; j < 80 ; j += 2) {
	     buf[i][j] = *temp ;
	     buf[i][j+1] = *(temp + 8152) ;
	     *temp=0 ;
	     *(temp+8152)=0 ;
	     temp ++ ;
	 }//end of for j =
	 i = 0 ;
	 do {
	     goto_xy(0, 0) ;
	     printf("define sides %d", sides + 1) ;
	     if(i == 0)
		 printf("enter first endpoint") ;
	     else
		 printf("enter second endpoints") ;
	     key.i = bioskey(0) ;
	     if(key.c[0] == 13) {
		  ob[sides][i++] = (double) x ;
		  ob[sides][i++] = (double) y ;
		  if(i == 4) {
		      i = 0 ;
		      sides ++ ;
		  }  //end of if
	     }//end of if
	       if(!key.c[0])
		  switch(key.c[1])  {
		       case 75 : y -= 1 ; break ;
		       case 77 : y += 1 ; break ;
		       case 72 : x =- 1 ; break ;
		       case 80 : x += 1 ; break ;
		       case 71 : x -= 1 ; y -= 1 ; break ;
		       case 73 : x -= 1 ; y += 1 ; break ;
		       case 79 : x += 1 ; y -= 1 ; break ;
		       case 81 : x += 1 ; y += 1 ; break ;
		   }//end of switch
	 } while(key.c[1] != 59) ;
	 temp = ptr ;
	for(i = 0 ; i < 14 ; i++)
	   for(j = 0 ; j < 80 ; j += 2) {
	       *temp=buf[i][j] ;
	       *(temp + 8152) = buf[i][j + 1] ;
	       temp ++ ;
	   }
	return sides ;
 }
//******************************