#include <dos.h>
#include <stdio.h>
#include <conio.h>
#include <math.h>
void mode(int), palette(int);
void box(int startx, int starty, int endx, int endy, int color);
void line(int startx, int starty, int endx, int endy, int color);
void fill_box(int startx, int starty, int endx, int endy, int color);
void circle(int x_center, int y_center, int radius, int color);
void plot_circle(int x, int y, int x_center, int y_center, int color);
void fill_circle(int x , int y , int r , int c);
void mempoint(int x , int y ,int color);

double asp_ratio ;

int main()
 {
     mode(4) ;
     palette(0) ;
     line(0, 0, 100, 100, 1) ;
     box(50, 50, 80, 90, 2) ;
     fill_box(100, 0, 120, 40, 3) ;
     circle(100, 160, 30, 2);
     fill_circle(150, 250, 20, 1) ;
     getch() ;
     mode(2) ;
     return 0;
 }
//************************
void palette(int pnum)
  {
       union REGS r ;
       r.h.bh = 1 ;
       r.h.bl = pnum ;
       r.h.ah = 0xB ;
       int86(0x10, &r, &r) ;
   }
//******************
void mode(int mode_code)
   {
       union REGS r ;
       r.h.al = mode_code ;
       r.h.ah = 0 ;
       int86(0x10, &r, &r) ;
   }
//**************
void box(int startx, int starty, int endx, int endy, int color)
   {
       line(startx , starty , endx , starty , color) ;
       line(startx , starty , startx , endy , color) ;
       line(startx , endy , endx , endy , color) ;
       line(endx , starty , endx , endy , color) ;
   }
//********************
void line(int startx, int starty, int endx, int endy, int color)
    {
       register int t , distance ;
       int xerr = 0 , yerr = 0 , deltax , deltay ;
       int incx , incy ;
       deltax = endx - startx ;
       deltay = endy - starty ;
       if(deltax > 0)
	  incx = 1 ;
       else if(deltax == 0)
	  incx = 0 ;
       else
	  incx =- 1 ;
       if(deltay > 0)
	  incy = 1 ;
       else if(deltay == 0)
	  incy = 0 ;
       else
	  incy =- 1 ;
       deltax = abs(deltax) ;
       deltay = abs(deltay) ;
       if(deltax > deltay)
	    distance = deltax ;
       else
	    distance = deltay ;
       for(t = 0 ; t < distance + 1 ; t++)  {
	  mempoint(startx , starty , color) ;
	  xerr += deltax ;
	  yerr += deltay ;
	  if(xerr > distance) {
	     xerr -= distance ;
	     startx+=incx ;
	  }
	  if(yerr > distance) {
	      yerr -= distance ;
	      starty+=incy ;
	  }
       }
 }
//******************
void fill_box(int startx, int starty, int endx, int endy, int color)
   {
       register int i , begin , end ;
       begin = startx < endx ? startx : endx ;
       end = startx > endx ? startx : endx ;
       for(i = begin ; i < end ; i++)
	  line(i , starty , i , endy , color) ;
   }
//************************
void circle(int x_center, int y_center, int radius, int color)
 {
     register int x , y , delta ;
     asp_ratio = 1.0 ;
     y = radius ;
     delta = 3 - 2 * radius ;
     for(x = 0 ; x < y ; )  {
	plot_circle(x, y, x_center, y_center, color) ;
	if(delta < 0)
	   delta += 4 * x + 6 ;
	else {
	     delta+=4*(x-y)+10 ;
	     y -- ;
	}//end of else
	x++ ;
     } //end of for
     x = y ;
     if ( y )
	plot_circle(x, y, x_center, y_center, color) ;
 }
//*********************
void plot_circle(int x, int y, int x_center, int y_center, int color)
   {
       int startx , endx , endy , x1 , starty , y1 ;
       starty = y * asp_ratio ;
       endy = (y + 1) * asp_ratio ;
       startx = x * asp_ratio ;
       endx = (x + 1) * asp_ratio ;
       for(x1 = startx ; x1 < endx ; ++x1)  {
	  mempoint(x1 + x_center , y + y_center , color) ;
	  mempoint(x1 + x_center , y_center - y , color) ;
	  mempoint(x_center - x1 , y_center - y , color) ;
	  mempoint(x_center - x1 ,  y + y_center , color) ;
       }
      for(y1=starty ; y1 < endy ; ++y1)  {
	 mempoint(y1 + x_center , x + y_center , color) ;
	 mempoint(y1 + x_center , y_center - x , color) ;
	 mempoint(x_center - y1 , y_center - x , color) ;
	 mempoint(x_center - y1 , x + y_center , color) ;
     }
 }
//*********************
void fill_circle(int x , int y , int r , int c)
  {
     while(r) {
	circle(x, y, r, c) ;
	r -- ;
     }
  }
//************************
void mempoint(int x , int y ,int color)
   {
      union mask {
	char c[2] ;
	int i ;
      } bit_mask ;
      int i , index , bitpos ;
      unsigned char t ;
      char xor ;
      char far *ptr = (char far *) 0xB8000000 ;
      bit_mask.i = 0xFF3F ; /* 11111111 00111111 */
      if(x < 0 || x > 199 || y < 0 || y > 319)
	 return ;
      xor = color & 128 ;
      color = color & 127 ;
      bitpos = y % 4 ;
      color <<= 2 * (3 - bitpos) ;
      bit_mask.i >>= 2 * bitpos ;
      index = x * 40 + (y / 4) ;
      if(x % 2)
	  index += 8152 ;
      if(!xor) {
	t =* (ptr + index) & bit_mask.c[0] ;
	*(ptr + index) = t | color ;
       }
      else {
	t =* (ptr + index) | (char) 0 ;
	*(ptr + index) = t ^ color ;
      }
 }

