#include <ctype.h>
#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
void code(char *input, char *output);
void decode(char *input, char *output);
int find(char *s, char ch);
char sub[28] = "qazwsxedcrfvtgbyhnujm ikolp";
char alphabet[28] = "abcdefghijklmnopqrstuvwxyz ";
int main(int argc, char *argv[])
{
  clrscr();
  if (argc != 4) {
      printf("usage:input output encode/decode\n");
      getch();
      exit(0);
  }
   if (toupper(*argv[3]) == 'E')
       code(argv[1], argv[2]);
   else
       decode(argv[1], argv[2]);
   return 0;
}
//*********************
void code(char *input, char *output)
{
   int ch;
   FILE *fp1, *fp2;
   if((fp1 = fopen(input, "r")) == 0) {
     printf("cannot open input file.\n");
     exit(0);
   }
   if((fp2 = fopen(output, "wt")) == 0) {
     printf("cannot open output file.\n");
     exit(0);
   }
   ch = getc(fp1);
   while(!feof(fp1)) {
	ch = tolower(ch);
	if(isalpha(ch) || ch == ' ')
	    ch = sub[find(alphabet, ch)];
	putc(ch, fp2);
	ch = getc(fp1);
   }
   fcloseall();
}//end of code
//**********************
void decode(char *input, char *output)
{
   int ch;
   FILE *fp1, *fp2;
   if((fp1 = fopen(input, "r")) == 0) {
     printf("cannot open input file.\n");
     exit(0);
   }
   if((fp2 = fopen(output, "w")) == 0) {
     printf("cannot open output file.\n");
     exit(0);
   }
   ch = tolower(getc(fp1));
   while(!feof(fp1)) {
       if(isalpha(ch) || ch == ' ')
	  ch = alphabet[find(sub, ch)];
       putc(ch, fp2);
       ch = tolower(getc(fp1));
   }
   fcloseall();
}
//******************
int find(char *s, char ch)
{
   register int t;
   for(t = 0; t < 28; t++)
	if(ch == s[t])
	     return t;
   return -1;
}


