# include <stdio.h>
# include <conio.h>
# include <string.h>
# include <stdlib.h>
# define READONLY        "r"
# define WRITEONLY       "w"
# define FALSE            0
# define TRUE             1
typedef  int              boolean;


# define NAMESIZE         21
# define SUBJECTSIZE      11
# define TRAILER          9999

# define INSERT           'I'
# define DELETE           'D'
# define CHANGE           'C'

char     *prog;
FILE     *fopen();

boolean get_transaction_record(FILE *fp,
       int *identification,
       char *transaction, char *name, char *subject,int *grade);

boolean get_master_record(FILE *fp,
int *identification, char *name, char *subject, int *grade);

boolean put_master_record(FILE *fp,
int identification,char *name,char *subject,int grade);

void  apply_transaction(boolean *allocated,
	  int tran_identification,
    char tran_transaction, char *tran_name,
    char *tran_subject,int tran_grade,
    int *new_identification, char *new_name,
    char *new_subject, int *new_grade);

void  do_initial_status(int current_key,
  boolean *allocated,FILE *fp, int *old_identification,
  char *old_name, char *old_subject,int *old_grade,
  int *new_identification, char *new_name,
  char *new_subject, int *new_grade);

void  do_final_status(FILE *fp,boolean allocated,
  int identification,char *name, char *subject, int grade);

void  copy_corresponding(
   int *dest_identification,char *dest_name,
   char *dest_subject, int *dest_grade,
   int sou_identification,
   char *sou_name, char *sou_subject, int sou_grade);

void  syserr (int errcode, char *message, char *argument);
void  error (char code, char *message, int id);

void main(int argc, char *argv[])
  {
   char b[21], c[11];
   int a, d, current_key;
   FILE    *fpold,*fptrans,*fpnew;
   boolean allocated;
   char    tran_transaction;
   int     old_identification, tran_identification,
	   new_identification;
   char    old_name[NAMESIZE], tran_name[NAMESIZE],
	   new_name[NAMESIZE];
   char    old_subject[SUBJECTSIZE], tran_subject[SUBJECTSIZE],
	   new_subject[SUBJECTSIZE];
   int     old_grade, tran_grade, new_grade;
   clrscr();
   prog = argv[0];
   if(argc !=4) syserr(1, "usage:%s file1 file2 file3\n", prog);

    else if((fpold = fopen(argv[1], READONLY)) == NULL)
       syserr(2, "cannot open %s\n",argv[1]);
    else if ((fptrans = fopen (argv[2], READONLY)) == NULL)
     syserr(2, "cannot open %s\n", argv[2]);
    else if (( fpnew = fopen (argv[3], WRITEONLY)) == NULL)
    syserr(2,"cannot open %s\n", argv[3]);
    else
    {
      get_master_record(fpold,  &old_identification,
		  old_name, old_subject,&old_grade);
      get_transaction_record(fptrans, &tran_identification,
		 &tran_transaction, tran_name,tran_subject,
		 &tran_grade) ;
      current_key = tran_identification < old_identification ?
      tran_identification : old_identification;
      while(current_key != TRAILER)
      {
	  do_initial_status(current_key, &allocated,
	    fpold, &old_identification, old_name,old_subject,
	    &old_grade, &new_identification,
	    new_name, new_subject, &new_grade);
	  while(current_key == tran_identification)
	  {
	      apply_transaction (&allocated, tran_identification,
		 tran_transaction,tran_name, tran_subject,tran_grade,
		 &new_identification,new_name, new_subject,&new_grade);

	     get_transaction_record(fptrans, &tran_identification,
		 &tran_transaction, tran_name, tran_subject, &tran_grade);
	  }//end of while
	  do_final_status (fpnew, allocated,
	     new_identification, new_name, new_subject,new_grade);

	  current_key=tran_identification < old_identification ?
	  tran_identification : old_identification  ;
      }//end of while
      copy_corresponding(&new_identification, new_name,
	  new_subject, &new_grade, 9999,
	  "zzzzzzzzzzzzzzzzzzzz", "zzzzzzzzzz", 9);
      put_master_record(fpnew,  new_identification,
	   new_name, new_subject, new_grade) ;

      fcloseall();
      printf("\n file new successfully created.");
      printf("\n press a key to continue...");
      getch();
   }
}
//*************************
boolean get_transaction_record(FILE *fp, int *identification,
       char *transaction, char *name, char *subject,int *grade)
{
     if (fscanf (fp,"%4d%c%20s%10s%2d",
     identification, transaction, name, subject, grade) == 5)
	    return(TRUE);
     return(FALSE);
}
//************************
boolean get_master_record(FILE *fp, int *identification,
		 char *name, char *subject, int *grade)
{
       if (fscanf (fp,"%4d%20s%10s%2d",
       identification,
		name,subject,grade)==4)
	      return(TRUE);
	return(FALSE);

}
//************************
boolean put_master_record(FILE *fp, int identification,
		char *name,char *subject,int grade)
{
   if(fprintf(fp, "%6d  %-20s  %-10s  %2d\n",
	  identification, name, subject, grade) != EOF)
      return(TRUE);
    return(FALSE);
}

//******************************
void  apply_transaction(boolean *allocated,
	  int tran_identification, char tran_transaction,
	  char *tran_name, char *tran_subject,int tran_grade,
	  int *new_identification, char *new_name,
	  char *new_subject, int *new_grade)
{
   switch(tran_transaction) {
     case  INSERT:
	 if(*allocated == TRUE)
	  error(INSERT, "record already exists\n",
	      tran_identification);
	 else {
	   copy_corresponding( new_identification,
	   new_name, new_subject, new_grade,
	   tran_identification, tran_name,tran_subject, tran_grade);

	   *allocated = TRUE;
	  }//end of else
	  break;
     case   DELETE:
	  if(*allocated == FALSE)
	   error(DELETE, "record dose not exist.", tran_identification);
	   else
	     *allocated = FALSE;
	   break;
     case  CHANGE:
	   if(*allocated == FALSE)
	    error(CHANGE, "record dose not exist.", tran_identification);
	   else
	    copy_corresponding( new_identification,
	      new_name, new_subject, new_grade,
	      tran_identification, tran_name,tran_subject, tran_grade);
	   break;
   }//end of switch
}//end of function
//********************************
void  do_initial_status(int current_key,
  boolean *allocated,FILE *fp, int *old_identification,
  char *old_name, char *old_subject,int *old_grade,
  int *new_identification, char *new_name,
  char *new_subject, int *new_grade)

{
   if(*old_identification == current_key)
   {
     copy_corresponding(new_identification, new_name,
     new_subject, new_grade, *old_identification,
     old_name,old_subject, *old_grade);
     *allocated = TRUE;
     get_master_record(fp, old_identification,
     old_name, old_subject, old_grade) ;
    }
    else
    *allocated=FALSE;
}
//**************************
void  do_final_status(FILE *fp,boolean allocated,
     int identification,char *name, char *subject, int grade)
{
     if(allocated)
     put_master_record(fp, identification, name, subject, grade) ;
}
//******************************
void  copy_corresponding(
   int *dest_identification,char *dest_name,
   char *dest_subject, int *dest_grade, int sou_identification,
   char *sou_name, char *sou_subject, int sou_grade)
{
    *dest_identification = sou_identification;
     strcpy(dest_name, sou_name);
     strcpy(dest_subject, sou_subject);
     *dest_grade = sou_grade;
}
//*********************
void  syserr (int errcode, char *message, char *argument)
{
    fprintf(stderr,"%s[%2d]:", prog, errcode);
    fprintf(stderr, message, argument);
    exit(errcode);
}
//*****************
void  error (char code, char *message, int id)
{
      printf("%c    %30s   %4d\n", code, message, id);
}

