#include <string.h>
#include <dos.h>
#include <bios.h>
#include <stdlib.h>
#include <stdio.h>
#include <conio.h>
#include <ctype.h>

#define BORDER   1
#define ESC      27
#define REV_VID  0x60
#define NORM_VID 2
int popup(char *menu[], char *keys, int count, int x, int y, int border);
void display_menu(char *menu[] , int x, int y, int count);
void draw_border(int startx, int starty, int endx, int endy);
int get_resp(int x, int y, int count, char *menu[], char *keys);
void write_string(int x, int y, char *p, int attrib);
void write_char(int x, int y, char ch, int attrib);
void save_video(int startx, int endx, int starty,
	    int endy, unsigned char *buf_ptr);
void restore_video(int startx, int endx, int starty,
		   int endy, unsigned char *buf_ptr);
int video_mode();
int is_in(char *s , char c);


char far *vid_mem ;
char *fruit[]={
		"apple     ",
		"orange    ",
		"pear      ",
		"grape     ",
		"raspberry ",
		"strawberry" } ;
char *color []={
	       "red",
	       "yellow",
	       "orange",
	       "green",} ;
char *apple_type[]={
	       "red delicious" ,
	       "jonthan",
	       "winesap",
	       "rome"};
int main()
  {
       int i,choice ;
       clrscr() ;
       choice=popup(fruit,"aoprts",6,1,3,BORDER) ;
       choice=popup(color , "ryog",4,5,10,BORDER) ;
       choice=popup(apple_type,"rjw",4,10,18,BORDER) ;
       if(choice == -2) 
	    printf("\n range error.");
       return 0;
   }
//**********************
int popup(char *menu[], char *keys, int count, int x, int y, int border)
  {
	 register int i , len ;
	 int endx , endy , choice , vmode ;
	 unsigned char *p ;
	 if((x>24) || (x<0) || (y>79) || (y<0))
	 {
	   printf("range") ;
	   return -2 ;
	 }
	 vmode = video_mode() ;
	 if((vmode!=2) && (vmode!=3) && (vmode!=7))
	 {
	   printf("video must be in 80 column text mode") ;
	   exit(1) ;
	 }
	 if(vmode==7)
	      vid_mem=(char far *) 0xB0000000 ;
	 else
	      vid_mem=(char far *) 0xB8000000 ;
	 len=0 ;
	 for(i=0 ; i<count ;i++)
	    if(strlen(menu[i]) > len) len=strlen(menu[i]) ;
	 endy=len+2+y ;
	 endx=count+1+x ;
	 if((endx+1 > 24) || (endy+1 >79))
	 {
	   printf("menu won't fit") ;
	   return -2 ;
	 }
	 p=(unsigned char *) malloc(2*(endx-x+1)*(endy-y+1)) ;
	 if(!p)
	    exit(1) ;
	 save_video(x,endx+1,y,endy+1,p);
	 if(border)
	     draw_border(x,y,endx,endy) ;
	 display_menu(menu , x+1 , y+1 , count) ;
	 choice=get_resp(x+1 , y , count , menu ,keys) ;
	 restore_video(x,endx+1 , y , endy+1 , p) ;
	 free(p) ;
	 return choice ;
 }
//************************
void display_menu(char *menu[] , int x, int y, int count)
   {
       register int i ;
       for(i=0 ; i < count ; i++ , x++)
	  write_string(x , y , menu[i] , NORM_VID) ;
   }
//**************************
void draw_border(int startx, int starty, int endx, int endy)
     {
      register int i ;
      char far *v , far *t ;
      v=vid_mem ;
      t=v ;
      for(i=startx+1 ; i<endx;i++)
      {
	v+=(i*160)+starty*2 ;
	*v++=179 ;
	*v=NORM_VID ;
	v=t ;
	v+=(i*160)+endy*2 ;
	*v++=179 ;
	*v=NORM_VID ;
	v=t ;
       }
      for(i=starty+1 ; i<endy;i++)
      {
	v+=(startx*160)+i*2 ;
	*v++=196 ;
	*v=NORM_VID ;
	v=t ;
	v+=(endx*160)+i*2 ;
	*v++=196 ;
	*v=NORM_VID ;
	v=t ;
       }
      write_char(startx , starty , 218 , NORM_VID) ;
      write_char(startx , endy , 191, NORM_VID) ;
      write_char(endx , starty , 192 , NORM_VID) ;
      write_char(endx , endy , 217 , NORM_VID) ;
  }
//************************
int get_resp(int x, int y, int count, char *menu[], char *keys)
  {
       union inkey {
		     char ch[2] ;
		     int i ;
		   } c ;
       int arrow_choice=0 , key_choice ;
       y++ ;
       gotoxy(x,y) ;
       write_string(x,y,menu[0],REV_VID) ;
       for(;;)
       {
	 while(!bioskey(1));
	     c.i=bioskey(0) ;
	 gotoxy(x+arrow_choice,y) ;
	 write_string(x+arrow_choice,y,menu[arrow_choice],NORM_VID);
	 if(c.ch[0])
	 {
	   key_choice=is_in(keys,tolower(c.ch[0])) ;
	   if(key_choice)
	      return key_choice-1 ;
	   switch(c.ch[0])
	   {
	     case '\r' : return arrow_choice ;
	     case ' '  : arrow_choice++ ;
		break ;
	     case ESC  : return -1 ;
	   }
	 }
	 else
	    {
	      switch(c.ch[1])
	      {
		case 72 : arrow_choice -- ;
		   break ;
		case 80 : arrow_choice ++ ;
		   break ;
	      }
	    }
	    if(arrow_choice==count)
	       arrow_choice=0 ;
	    if(arrow_choice<0)
	       arrow_choice=count-1 ;
	    gotoxy(x+arrow_choice,y) ;
	    write_string(x+arrow_choice,y,menu[arrow_choice],REV_VID);
	 }
  }
//*************************
void write_string(int x, int y, char *p, int attrib)
  {
       register int i ;
       char far *v;
       v = vid_mem ;
       v += (x*160) + y*2 ;
       for (i=y ;*p;i++)
       {
	 *v++=*p++ ;
	 *v++=attrib ;
       }
  }
//**********************
void write_char(int x, int y, char ch, int attrib)
   {
       register int i ;
       char far *v ;
       v = vid_mem ;
       v += (x * 160) + y * 2 ;
       *v++ = ch ;
       *v = attrib ;
   }
//*************
void save_video(int startx, int endx, int starty,
	    int endy, unsigned char *buf_ptr)
  {
       register int i , j ;
       char far *v , far *t ;
       v=vid_mem ;
       for(i=starty ; i<endy;i++)
	 for(j=startx;j<endx;j++)
	 {
	   t=v+(j*160)+i*2 ;
	   *buf_ptr++=*t++ ;
	   *buf_ptr++=*t ;
	   *(t-1)=' ' ;
	 }
   }
//************************
void restore_video(int startx, int endx, int starty,
		   int endy, unsigned char *buf_ptr)
    {
       register int i , j ;
       char far *v , far *t ;
       v = vid_mem ;
       t = v ;
       for(i = starty ; i< endy;i++)
	 for(j = startx; j < endx;j++)
	 {
	   v=t ;
	   v+=(j*160) + i*2 ;
	   *v++=*buf_ptr++ ;
	   *v=*buf_ptr++ ;
	 }
   }
//*******************
int video_mode()
     {
       union REGS  r ;
       r.h.ah=15 ;
       return int86(0x10 , &r , &r) & 255 ;
     }
//**********************
int is_in(char *s , char c)
     {
       register int i ;
       for(i=0 ; *s ; i++)
	  if(*s++==c)
	     return i+1 ;
       return 0 ;
     }












