#include <dos.h>
#include <stdio.h>
#include <conio.h>
#include <ctype.h>
#include <math.h>
void mode(int mode);
void palette(int pnum);
void line(int startx, int starty, int endx, int endy, int color);
void mempoint(int x , int y ,int color);
void rotate_point(double theta, double *x, double *y,
		  int x_org, int y_org);
void rotate_object(double ob[][4], double theta, int x, int y, int sides);
void display_object(double ob[][4], int sides);
double house[][4]= {
	 120, 120, 120, 200 , /* house */
	 120, 200, 80,  200 ,
	 80,  120, 80,  200 ,
	 80,  120, 120, 120 ,
	 60,  160, 80,  120 ,  /* roof */
	 60,  160, 80,  200 ,
	 120, 155, 100, 155 , /* door */
	 100, 155, 100, 165 ,
	 100, 165, 120, 165 ,
	 90,  130, 100, 130 , /* window */
	 90,  130, 90,  140 ,
	 100, 130, 100, 140 ,
	 90,  140, 100, 140 ,
	 90,  180, 100, 180 ,
	 90,  180, 90,  190 ,
	 100, 180, 100, 190 ,
	 90,  190, 100, 190
  } ;

int main()
{
    union k {
	     char c[2] ;
	     int i ;
	    } key ;
    mode(4) ;
    palette(0) ;
    /* drow a box around the house */
    line(30, 70, 30, 260, 2) ;
    line(160, 70, 160, 260, 2) ;
    line(30, 70, 160, 70, 2) ;
    line(30, 260, 160, 260, 2) ;
    display_object(house, 17) ;
/*    getch() ;*/
    rotate_object(house, 0.25, 90, 160, 17);
    mode(3) ;
    return 0;
  }
//**********************
void mode(int mode_code)
     {
       union REGS r ;
       r.h.al=mode_code ;
       r.h.ah=0 ;
       int86(0x10,&r,&r) ;
     }
//**********************
void palette(int pnum)
   {
       union REGS r ;
       r.h.bh = 1 ;
       r.h.bl = pnum ;
       r.h.ah = 0xB ;
       int86(0x10, &r, &r) ;
   }
//*********************
void line(int startx, int starty, int endx, int endy, int color)
     {
       register int t, distance ;
       int xerr = 0, yerr = 0, deltax, deltay ;
       int incx , incy ;
       deltax = endx - startx ;
       deltay = endy - starty ;
       if(deltax > 0)
	  incx = 1 ;
       else if(deltax == 0)
	  incx = 0 ;
       else
	  incx =- 1 ;
       if(deltay > 0)
	  incy = 1 ;
       else if(deltay == 0)
	  incy = 0 ;
       else
	  incy =- 1 ;
       deltax = abs(deltax) ;
       deltay = abs(deltay) ;
       if(deltax > deltay)
	    distance = deltax ;
       else
	    distance = deltay ;
       for(t = 0 ; t < distance + 1 ; t++)  {
	    mempoint(startx , starty , color) ;
	    xerr += deltax ;
	    yerr += deltay ;
	   if(xerr > distance) 	{
		xerr -= distance ;
		startx += incx ;
	   }
	   if(yerr > distance) {
		yerr -= distance ;
		starty += incy ;
	   }
       }//end of for
 }
//********************
void mempoint(int x , int y ,int color)
 {
      union mask {
	 char c[2] ;
	 int i ;
      } bit_mask ;
      int i, index, bitpos ;
      unsigned char t ;
      char xor ;
      char far *ptr = (char far *) 0xB8000000 ;
      bit_mask.i = 0xFF3F ; /* 11111111 00111111 */
      if(x < 0 || x > 199 || y < 0 || y > 319)
	 return ;
      xor = color & 128 ;
      color = color & 127 ;
      bitpos = y % 4 ;
      color <<= 2 * (3 - bitpos) ;
      bit_mask.i >>= 2 * bitpos ;
      index = x * 40 + (y / 4) ;
      if(x % 2)
	  index += 8152 ;
      if(!xor) {
	   t = *(ptr + index) & bit_mask.c[0] ;
	   *(ptr + index) = t | color ;
      }
      else  {
	  t= *(ptr + index) | (char) 0 ;
	  *(ptr + index) = t ^ color ;
      }
 }
//***********************
void rotate_point(double theta, double *x, double *y,
		  int x_org, int y_org)
 {
       double tx, ty ;
       tx = *x - x_org ;
       ty = *y - y_org ;
       /* rotate */
       *x = tx * cos(theta) - ty * sin(theta) ;
       *y = tx * sin(theta) - ty * cos(theta) ;
       *x += x_org ;
       *y += y_org ;
 }
//************************
void rotate_object(double ob[][4], double theta, int x, int y, int sides)
  {
       register int i , j ;
       double tempx , tempy ;
       char ch ;
       puts("r = right, l = left, otherkey = exit");
       for(;;)  {
	   ch = getch() ;
	   switch(tolower(ch))  {
	      case 'l' :
		 theta = theta < 0 ? - theta : theta ;
		 break ;
	      case 'r' :
		 theta = theta > 0 ? - theta : theta ;
		 break ;
	      default : return ;
	   }
	   for(j = 0 ; j < sides ; j++) {
	   /* erase old line */
	       line((int) ob[j][0] , (int)ob[j][1] ,
			(int) ob[j][2] , (int)ob[j][3] , 0) ;
	       rotate_point(theta , &ob[j][0], &ob[j][1], x, y) ;
	       rotate_point(theta , &ob[j][2], &ob[j][3], x, y) ;
	       line((int) ob[j][0] ,(int) ob[j][1] ,
			(int) ob[j][2] , (int) ob[j][3], 2) ;
	   } //end of for j =
       }//end of for (;;)
 }
//****************************
void display_object(double ob[][4], int sides)
 {
       register int i ;
       for(i = 0 ; i < sides ; i++)
	   line((int) ob[i][0] , (int)ob[i][1] ,
		(int) ob[i][2] , (int)ob[i][3] , 2) ;
 }
//*****************************

