#include <ctype.h>
#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
void compress(char *input, char *output);
void decompress(char *input, char *output);
int main(int argc, char *argv[])
{
  clrscr();
  if (argc != 4) {
      printf("usage:input output compress/decompress\n");
      getch();
      exit(0);
  }
  if (toupper(*argv[3]) == 'C')
       compress(argv[1], argv[2]);
   else
       decompress(argv[1], argv[2]);
   return 0;
}
//*********************
void compress(char *input, char *output)
{
   char  ch, ch2, t;
   FILE *fp1, *fp2;
   if((fp1 = fopen(input, "r")) == 0) {
     printf("cannot open input file.\n");
     exit(0);
   }
   if((fp2 = fopen(output, "wt")) == 0) {
     printf("cannot open output file.\n");
     exit(0);
   }
   do {
       ch = getc(fp1);
       if(feof(fp1)) break;
       ch = ch << 1;
       for(t = 0; t < 7; ++t) {
	    ch2 = getc(fp1);
	    if (feof(fp1))
	       ch2 = 0;
	    ch2 = ch2 & 127;    // turn off top bit
	    ch2 = ch2 | ((ch << t) & 128);
	    putc(ch2, fp2);
       }
   } while(!feof(fp1));
   fcloseall();
}//end of code
//**********************
void decompress(char *input, char *output)
{
   unsigned char ch, ch2, t, done;
   char s[7], temp;
   FILE *fp1, *fp2;
   if((fp1 = fopen(input, "r")) == 0) {
     printf("cannot open input file.\n");
     exit(0);
   }
   if((fp2 = fopen(output, "w")) == 0) {
     printf("cannot open output file.\n");
     exit(0);
   }
   do {
       ch = 0;
       for(t = 0; t < 7; t++) {
	  temp = getc(fp1);
	  if(temp == EOF) break;
	  ch2 = temp;
	  s[t] = ch2 & 127 ; // turn off top bit
	  ch2 = ch2 & 128 ; // turn off all but top bit
	  ch2 = ch2 >> t + 1;
	  ch = ch | ch2;
       }
       putc(ch, fp2);
       for(t = 0; t < 7 && s[t]; t ++)
	   putc(s[t], fp2);
       for(t = 0; t < 7; t ++)  //nul the s sting for next use
	     s[t] = 0;
   } while (!feof(fp1));
   fcloseall();
}
