using System;              // For String, Int32, Console
using System.Text;         // For Encoding
using System.Net;          // For IPAddress 
using System.Net.Sockets;  // For TcpListener, TcpClient, NetworkStream

public class TranscodeServer {

  public static readonly int BUFSIZE = 1024;  // Size of read buffer

  public static void Main(string[] args) {

    if (args.Length != 1)  // Test for correct # of args
      throw new ArgumentException("Parameter(s): <Port>");

    int servPort = Int32.Parse(args[0]);  // Server port

    // Create a TcpListener to accept client connection requests
    TcpListener listener = new TcpListener(IPAddress.Any, servPort);
    listener.Start();

    byte[] buffer = new byte[BUFSIZE];   // Allocate read/write buffer
    int bytesRead;                       // Number of bytes read
    for (;;) { // Run forever, accepting and servicing connections
      // Wait for client to connect, then create a new TcpClient
      TcpClient client = listener.AcceptTcpClient();

      Console.WriteLine("\nHandling client...");

      // Get the input and output streams from socket
      NetworkStream netStream = client.GetStream();

      int totalBytesRead = 0;
      int totalBytesWritten = 0;

      Decoder uniDecoder = Encoding.Unicode.GetDecoder();
      Char[] chars = null;

      // Receive until client closes connection, indicated by 0 return
      while ((bytesRead = netStream.Read(buffer, 0, buffer.Length)) > 0) {
        totalBytesRead += bytesRead;

        // Convert the incoming bytes to Unicode char array
        int charCount = uniDecoder.GetCharCount(buffer, 0, bytesRead);
        chars = new Char[charCount];
        int charsDecodedCount = uniDecoder.GetChars(buffer, 0, bytesRead, chars, 0);

        // Convert the Unicode char array to UTF8 bytes
        int byteCount = Encoding.UTF8.GetByteCount(chars, 0, charsDecodedCount);
        byte[] outputBuffer = new byte[byteCount];
        Encoding.UTF8.GetBytes(chars, 0, charsDecodedCount, outputBuffer, 0);

        // Send UTF8 bytes back to client
        netStream.Write(outputBuffer, 0, outputBuffer.Length);
        totalBytesWritten += outputBuffer.Length;
      }

      Console.WriteLine("Total bytes read:    {0}", totalBytesRead);
      Console.WriteLine("Total bytes written: {0}", totalBytesWritten);
      Console.WriteLine("Closing client connection...");

      netStream.Close(); // Close the stream 
      client.Close();    // Close the socket
    }
    /* NOT REACHED */
  }
}
