using System;               // For Int32, ArgumentException
using System.Threading;     // For Thread
using System.Net;           // For IPAddress
using System.Net.Sockets;   // For TcpListener, Socket

class TcpEchoServerThread {

  static void Main(string[] args) {

    if (args.Length != 1)  // Test for correct # of args
      throw new ArgumentException("Parameter(s): <Port>");

    int echoServPort = Int32.Parse(args[0]);  // Server port

    // Create a TcpListener socket to accept client connection requests
    TcpListener listener = new TcpListener(IPAddress.Any, echoServPort);
 
    ILogger logger = new ConsoleLogger();  // Log messages to console

    listener.Start();

    // Run forever, accepting and spawning threads to service each connection
    for (;;) {
      try {
        Socket clntSock = listener.AcceptSocket();  // Block waiting for connection
        EchoProtocol protocol = new EchoProtocol(clntSock, logger);
        Thread thread = new Thread(new ThreadStart(protocol.handleclient));
        thread.Start();
        logger.writeEntry("Created and started Thread = " + thread.GetHashCode());
      } catch (System.IO.IOException e) {
        logger.writeEntry("Exception = " + e.Message);
      }
    }
    /* NOT REACHED */
  }
}
