using System;             // For Int32, ArgumentException
using System.Threading;   // For Thread
using System.Net;         // For IPAddress
using System.Net.Sockets; // For TcpListener

public class TcpEchoServerPool {

  public static void Main(string[] args) {

    if (args.Length != 2)  // Test for correct # of args
      throw new ArgumentException("Parameter(s): <Port> <Threads>");

    int servPort = Int32.Parse(args[0]);    // Server port
    int numThreads = Int32.Parse(args[1]);  // Get number of threads

    // Create a TcpListener to accept client connection requests
    TcpListener listener = new TcpListener(IPAddress.Any, servPort);
    listener.Start();
 
    ILogger logger = new ConsoleLogger();  // Log messages to console

    // Create N-1 threads, each running an iterative server
    for (int i = 0; i < numThreads; i++) { 
      DispatchLoop dl = new DispatchLoop(listener, logger);
      Thread thread = new Thread(new ThreadStart(dl.rundispatcher));
      thread.Start();
      logger.writeEntry("Created and started Thread = " + thread.GetHashCode());
    }
  }
}

class DispatchLoop {
  TcpListener listener;
  ILogger logger;

  public DispatchLoop(TcpListener listener, ILogger logger) {
    this.listener = listener;
    this.logger   = logger;
  }	

  public void rundispatcher() {
    // Run forever, accepting and handling each connection
    for (;;) {
      try {
        Socket clntSock = listener.AcceptSocket();  // Block waiting for connection
        EchoProtocol protocol = new EchoProtocol(clntSock, logger);
        protocol.handleclient();
      } catch (SocketException se) {
        logger.writeEntry("Exception = " +  se.Message);
      }
    }
  }
}
