using System;             // For String, IAsyncResult, Console
using System.Text;        // For ASCIIEncoding
using System.Net;         // For IPEndPoint
using System.Net.Sockets; // For Socket and associated classes
using System.Threading;   // For ManualResetEvent

class TcpEchoClientAsyncSocket {

  public static byte[] byteBuffer;
  public static String server;
  public static int servPort;
  public static int totalBytesRcvd = 0;     // Total bytes received so far
  public static ASCIIEncoding encode = new ASCIIEncoding();
  public static string echoResponse = "";

  public static ManualResetEvent socketEvent = new ManualResetEvent(false);

  static void Main(string[] args) {

    if ((args.Length < 2) || (args.Length > 3)) { // Test for correct # of args
      throw new System.ArgumentException("Parameters: <Server> <Word> [<Port>]");
    }

    server = args[0];     // Server name or IP address
    // Convert input String to bytes 
    byteBuffer = encode.GetBytes(args[1]);

    // Use port argument if supplied, otherwise default to 7
    servPort = (args.Length == 3) ? Int32.Parse(args[2]) : 7;

    Console.WriteLine("Thread {0} ({1}) - Main()", Thread.CurrentThread.GetHashCode(), 
                      Thread.CurrentThread.ThreadState);

    // Create socket that is connected to server on specified port
    Socket sock = new Socket(AddressFamily.InterNetwork, SocketType.Stream,
                             ProtocolType.Tcp);

    IPEndPoint ipep = new IPEndPoint(Dns.Resolve(server).AddressList[0], servPort);
    sock.BeginConnect(ipep, new AsyncCallback(ConnectCallback), sock);

    doOtherStuff();

    socketEvent.WaitOne();

    socketEvent.Reset();

    // Send the encoded string to the server
    sock.BeginSend(byteBuffer, 0, byteBuffer.Length, SocketFlags.None, 
                   new AsyncCallback(SendCallback), sock);

    doOtherStuff();

    socketEvent.WaitOne();

    socketEvent.Reset();

    // Receive the same string back from the server
    sock.BeginReceive(byteBuffer, totalBytesRcvd, byteBuffer.Length - totalBytesRcvd, 
                      SocketFlags.None, new AsyncCallback(ReceiveCallback), sock);

    doOtherStuff();

    socketEvent.WaitOne();

    sock.Shutdown(SocketShutdown.Both);
    sock.Close();
  }
  
  public static void doOtherStuff() {
    for (int x=1; x<=5; x++) {
      Console.WriteLine("Thread {0} ({1}) - doOtherStuff(): {2}...", 
                        Thread.CurrentThread.GetHashCode(), Thread.CurrentThread.ThreadState, x);
      Thread.Sleep(10);
    }
  }
 
  public static void ConnectCallback(IAsyncResult asyncResult) {

    Socket sock = (Socket) asyncResult.AsyncState;
    sock.EndConnect(asyncResult);

    Console.WriteLine("Thread {0} ({1}) - ConnectCallback(): Connected to server...", 
                      Thread.CurrentThread.GetHashCode(), Thread.CurrentThread.ThreadState);
    socketEvent.Set();
  }

  public static void SendCallback(IAsyncResult asyncResult) {

    Socket sock = (Socket) asyncResult.AsyncState;
    int bytesSent = sock.EndSend(asyncResult);
    Console.WriteLine("Thread {0} ({1}) - SendCallback(): Sent {2} bytes...", 
                      Thread.CurrentThread.GetHashCode(),
                      Thread.CurrentThread.ThreadState, bytesSent);

    socketEvent.Set();
  }

  public static void ReceiveCallback(IAsyncResult asyncResult) {

    Socket sock = (Socket) asyncResult.AsyncState;
    int bytesRcvd = sock.EndReceive(asyncResult);

    totalBytesRcvd += bytesRcvd;
    echoResponse += encode.GetString(byteBuffer, 0, bytesRcvd);

    if (totalBytesRcvd < byteBuffer.Length) {
      Console.WriteLine("Thread {0} ({1}) - ReceiveCallback(): Received {2} bytes...", 
                        Thread.CurrentThread.GetHashCode(),
                        Thread.CurrentThread.ThreadState, bytesRcvd);
      sock.BeginReceive(byteBuffer, totalBytesRcvd, byteBuffer.Length - totalBytesRcvd, 
                        SocketFlags.None, new AsyncCallback(ReceiveCallback), sock);
    } else {
      Console.WriteLine("Thread {0} ({1}) - ReceiveCallback(): Received {2} total bytes: {3}", 
                        Thread.CurrentThread .GetHashCode(),
                        Thread.CurrentThread.ThreadState, totalBytesRcvd, echoResponse);
      socketEvent.Set();
    }
  }
}
