using System;              // For Console, Int32, ArguementException
using System.Net;          // For EndPoint, IPEndPoint
using System.Net.Sockets;  // For Socket, SocketFlags

class UdpEchoServerSocket {

  private const int ECHOMAX = 255; // Maximum size of echo datagram

  static void Main(string[] args) {

    if (args.Length != 1) { // Test for correct # of args
      throw new ArgumentException("Parameters: <Port>");
    }

    int servPort = Int32.Parse(args[0]);

    Socket server = new Socket(AddressFamily.InterNetwork, 
                               SocketType.Dgram, ProtocolType.Udp);

    IPEndPoint localIPEndPoint = new IPEndPoint(IPAddress.Any, servPort);
    server.Bind((EndPoint)localIPEndPoint);

    EndPoint remoteEndPoint = (EndPoint)localIPEndPoint;
    byte[] byteBuffer = new byte[ECHOMAX];

    for (;;) {  // Run forever, receiving and echoing datagrams
      try {
        int bytesRcvd = server.ReceiveFrom(byteBuffer, ref remoteEndPoint);
        Console.Write("Handling client at " + remoteEndPoint + " - ");

        // Send an echo packet back to the client
        server.SendTo(byteBuffer, bytesRcvd, SocketFlags.None, remoteEndPoint); 
        Console.WriteLine("echoed {0} bytes.", bytesRcvd);
      } catch (SocketException se) {
        Console.WriteLine(se.ErrorCode + ": " + se.Message);
      } 
    } 
  }
}
