using System;              // For Console, Int32, ArgumentException, Environment
using System.Net;          // For IPEndPoint
using System.Net.Sockets;  // For UdpClient, SocketException

class UdpEchoServer {

  static void Main(string[] args) {

    if (args.Length > 1) { // Test for correct # of args
      throw new ArgumentException("Parameters: <Port>");
    }

    int servPort = (args.Length == 1) ? Int32.Parse(args[0]) : 7;

    UdpClient client = null;

    try {
      // Create an instance of UdpClient on the port to listen on
      client = new UdpClient(servPort);
    } catch (SocketException se) {
      Console.WriteLine(se.ErrorCode + ": " + se.Message);
      Environment.Exit(se.ErrorCode);
    }

    // Create an IPEndPoint instance that will be passed as a reference
    // to the Receive() call and be populated with the remote client info
    IPEndPoint remoteIPEndPoint = new IPEndPoint(IPAddress.Any, 0);
 
    for (;;) {  // Run forever, receiving and echoing datagrams
      try { 
        // Receive a byte array with echo datagram packet contents
        byte[] byteBuffer = client.Receive(ref remoteIPEndPoint);
        Console.Write("Handling client at " + remoteIPEndPoint + " - ");
 
        // Send an echo packet back to the client
        client.Send(byteBuffer, byteBuffer.Length, remoteIPEndPoint); 
        Console.WriteLine("echoed {0} bytes.", byteBuffer.Length);
      } catch (SocketException se) {
        Console.WriteLine(se.ErrorCode + ": " + se.Message);
      }
    }
  }
}
