using System;              // For Console, Int32, ArgumentException
using System.Net;          // For IPEndPoint
using System.Net.Sockets;  // For UdpClient, SocketException

class UdpDeadEchoServer {

  // This class is a server that receives connections but does not
  // echo. It can be used to test the UdpEchoClientTimeout program.

  static void Main(string[] args) {

    if (args.Length != 1) { // Test for correct # of args
      throw new ArgumentException("Parameters: <Port>");
    }

    int servPort = Int32.Parse(args[0]);

    UdpClient client = null;
    try {
      // Create an instance of UdpClient on the port to listen on
      client = new UdpClient(servPort);

      // Create an IPEndPoint instance that will be passed as a reference
      // to the Receive() call and be populated with the remote client info
      IPEndPoint remoteIPEndPoint = new IPEndPoint(IPAddress.Any, 0);
 
      for (;;) {  // Run forever, receiving and echoing datagrams
        // Receive a byte array with echo datagram packet contents
        byte[] byteBuffer = client.Receive(ref remoteIPEndPoint);
        Console.Write("Handling client at " + remoteIPEndPoint + " - ");
 
        // Do NOT send an echo packet back to the client
        Console.WriteLine("received {0} bytes. Not echoing.", byteBuffer.Length);
      }
    } catch (SocketException se) {
      Console.WriteLine(se.ErrorCode + ": " + se.Message);
    } finally {
      client.Close();
    }
  }
}
