using System;              // For Console, Int32, ArgumentException, Environment
using System.Net;          // For IPAddress
using System.Net.Sockets;  // For TcpListener, TcpClient
using System.Threading;    // For Thread

class TcpSlowEchoServer {

  private const int BUFSIZE = 32;         // Size of receive buffer
  private const int SLEEP_TIME_MS = 4000; // Time to sleep (milliseconds)

  static void Main(string[] args) {

    if (args.Length > 1) // Test for correct # of args
      throw new ArgumentException("Parameters: [<Port>]");
  
    int servPort = (args.Length == 1) ? Int32.Parse(args[0]): 7;

    TcpListener listener = null;

    try {
      // Create a TCPListener to accept client connections
      listener = new TcpListener(IPAddress.Any, servPort);
      listener.Start();
    } catch (SocketException se) { 
      Console.WriteLine(se.ErrorCode + ": " + se.Message);
      Environment.Exit(se.ErrorCode);
    }

    byte[] rcvBuffer = new byte[BUFSIZE]; // Receive buffer
    int bytesRcvd;                        // Received byte count

    for (;;) { // Run forever, accepting and servicing connections

      Thread.Sleep(SLEEP_TIME_MS);

      TcpClient client = null;
      NetworkStream netStream = null;

      try {
        Thread.Sleep(SLEEP_TIME_MS);
        client = listener.AcceptTcpClient(); // Get client connection
        Thread.Sleep(SLEEP_TIME_MS);
        netStream = client.GetStream();
        Console.Write("Handling client - ");

        Thread.Sleep(SLEEP_TIME_MS);

        // Receive until client closes connection, indicated by 0 return value
        int totalBytesEchoed = 0;
        while ((bytesRcvd = netStream.Read(rcvBuffer, 0, rcvBuffer.Length)) > 0) {
          Thread.Sleep(SLEEP_TIME_MS);
          netStream.Write(rcvBuffer, 0, bytesRcvd);
          totalBytesEchoed += bytesRcvd;
          Thread.Sleep(SLEEP_TIME_MS);
        } 
        Console.WriteLine("echoed {0} bytes.", totalBytesEchoed);

        Thread.Sleep(SLEEP_TIME_MS);

        // Close the stream and socket. We are done with this client!
        netStream.Close(); 
        client.Close();   

      } catch (Exception e) { 
        Console.WriteLine(e.Message);
        netStream.Close();
      }
    }
  }
}
