using System;              // For String, Int32, Console, ArgumentException
using System.Text;         // For Encoding
using System.IO;           // For IOException
using System.Net.Sockets;  // For TcpClient, NetworkStream, SocketException

class TcpEchoClientNoRead {

  // This is a "bad client" that opens a connection but never sends any
  // data. It can be used to test the behavior of the server code when
  // confronted with a malfunctioning client

  static void Main(string[] args) {

    if ((args.Length < 2) || (args.Length > 3)) { // Test for correct # of args
      throw new System.ArgumentException("Parameters: <Server> <Word> [<Port>]");
    }

    String server = args[0];     // Server name or IP address

    // Convert input String to bytes 
    byte[] byteBuffer = Encoding.ASCII.GetBytes(args[1]);

    // Use port argument if supplied, otherwise default to 7
    int servPort = (args.Length == 3) ? Int32.Parse(args[2]) : 7;

    TcpClient tcpclient = null;
    NetworkStream netStream= null;

    try {
      // Create socket that is connected to server on specified port
      tcpclient = new TcpClient(server, servPort);

      Console.WriteLine("Connected to server... sending echo string");
    
      netStream = tcpclient.GetStream();

      // Send the encoded string to the server
      netStream.Write(byteBuffer, 0, byteBuffer.Length);

    } catch (Exception e) {
      Console.WriteLine(e.Message);
    } finally {
//      netStream.Close();
//      client.Close();
    }

    Console.WriteLine("About to go into infinite loop - press ctrl-C to exit");

    while (true) {}

    // NEVER REACHED, CLIENT NEVER RECEIVES OR CLOSES CONNECTION
  }
}
