using System;             // For String, Int32, Console, ArgumentException
using System.IO;          // For FileStream
using System.Net.Sockets; // For NetworkStream, TcpClient

public class TranscodeClient {

  private const int BUFSIZE = 256;  // Size of read buffer

  private static NetworkStream netStream;
  private static FileStream fileIn;
  private static TcpClientShutdown client;

  public static void Main(string[] args) {

    if (args.Length != 3)  // Test for correct # of args
      throw new ArgumentException("Parameter(s): <Server> <Port> <File>");

    String server = args[0];          // Server name or IP address
    int port = Int32.Parse(args[1]);  // Server port
    String filename = args[2];        // File to read data from

    // Open input and output file (named <input>.ut8)
    fileIn = new FileStream(filename, FileMode.Open, FileAccess.Read);
    FileStream fileOut = new FileStream(filename + ".ut8", FileMode.Create);
  
    // Create TcpClient connected to server on specified port
    client = new TcpClientShutdown();
    client.Connect(server, port);

    // Send non-encoded byte stream to server
    netStream = client.GetStream();
    sendBytes();

    // Receive encoded byte stream from server
    int bytesRead;                      // Number of bytes read
    byte[] buffer = new byte[BUFSIZE];  // Byte buffer
    while ((bytesRead = netStream.Read(buffer, 0, buffer.Length)) > 0) {
      fileOut.Write(buffer, 0, bytesRead);
      Console.Write("R");   // Reading progress indicator
    }
    
    Console.WriteLine(); // End progress indicator line

    netStream.Close(); // Close the stream
    client.Close();    // Close the socket
    fileIn.Close();    // Close input file 
    fileOut.Close();   // Close output file
  }

  private static void sendBytes() {
    int bytesRead;                      // Number of bytes read
    BufferedStream fileInBuf = new BufferedStream(fileIn);
    byte[] buffer = new byte[BUFSIZE];  // Byte buffer
    while ((bytesRead = fileInBuf.Read(buffer, 0, buffer.Length)) > 0) {
      netStream.Write(buffer, 0, bytesRead);
      Console.Write("W");   // Writing progress indicator
    }
    client.Shutdown(SocketShutdown.Send);     // Done sending
  }
}
