using System;            // For String
using System.Threading;  // For Thread

class MyThreadClass {
  // Class that takes a String greeting as input, then outputs that
  // greeting to the console 10 times in its own thread with a random 
  // interval between each greeting.

  private const int RANDOM_SLEEP_MAX = 500; // Max random milliseconds to sleep
  private const int LOOP_COUNT = 10;        // Number of times to print message

  private String greeting;   // Message to print to console

  public MyThreadClass(String greeting) {
    this.greeting = greeting;
  }

  public void runMyThread() {
    Random rand = new Random();

    for (int x=0; x < LOOP_COUNT; x++) {
      Console.WriteLine("Thread-" + Thread.CurrentThread.GetHashCode() + ": " + 
                        greeting);
      try { 
        // Sleep 0 to RANDOM_SLEEP_MAX milliseconds
        Thread.Sleep(rand.Next(RANDOM_SLEEP_MAX)); 
      } catch (ThreadInterruptedException) {}  // Will not happen
    }
  }
}

class ThreadExample {
  
  static void Main(string[] args) {

    MyThreadClass mtc1 = new MyThreadClass("Hello");
    new Thread(new ThreadStart(mtc1.runMyThread)).Start();

    MyThreadClass mtc2 = new MyThreadClass("Aloha");
    new Thread(new ThreadStart(mtc2.runMyThread)).Start();

    MyThreadClass mtc3 = new MyThreadClass("Ciao");
    new Thread(new ThreadStart(mtc3.runMyThread)).Start();
  }
}
