using System;              // For Int32, ArgumentException
using System.Net;          // For IPAddress, IPEndpoint
using System.Net.Sockets;  // For Socket and associated classes

public class SendUdpMulticast {

  public static void Main(string[] args) {

    if ((args.Length < 2) || (args.Length > 3)) // Test for correct # of args
      throw new ArgumentException(
        "Parameter(s): <Multicast Addr> <Port> [<TTL>]");

    IPAddress destAddr = IPAddress.Parse(args[0]);  // Destination address

    if (! MCIPAddress.isValid(args[0]))
      throw new ArgumentException("Valid MC addr: 224.0.0.0 - 239.255.255.255");

    int destPort = Int32.Parse(args[1]);  // Destination port

    int TTL;   // Time to live for datagram
    if (args.Length == 3)
      TTL = Int32.Parse(args[2]);
    else
      TTL = 1;  // Default TTL

    ItemQuote quote = new ItemQuote(1234567890987654L, "5mm Super Widgets", 
                                    1000, 12999, true, false);

    Socket sock = new Socket(AddressFamily.InterNetwork, 
                             SocketType.Dgram,
                             ProtocolType.Udp ); // Multicast socket to sending

    // Set the Time to Live                          
    sock.SetSocketOption(SocketOptionLevel.IP,
                         SocketOptionName.MulticastTimeToLive, 
                         TTL);

    ItemQuoteEncoderText encoder = new ItemQuoteEncoderText();  // Text encoding
    byte[] codedQuote = encoder.encode(quote);

    // Create an IP endpoint class instance
    IPEndPoint ipep = new IPEndPoint(destAddr, destPort);

    // Create and send a packet
    sock.SendTo(codedQuote, 0, codedQuote.Length, SocketFlags.None, ipep);

    sock.Close();
  }
}
