using System;              // For Console, Int32, ArgumentException
using System.Net;          // For IPAddress, EndPoinit, IPEndPoint
using System.Net.Sockets;  // For Socket and associated classes

public class RecvUdpMulticast {

  public static void Main(string[] args) {

    if (args.Length != 2)  // Test for correct # of args
      throw new ArgumentException("Parameter(s): <Multicast Addr> <Port>");

    IPAddress address = IPAddress.Parse(args[0]);  // Multicast address
    
    if (! MCIPAddress.isValid(args[0]))
      throw new ArgumentException("Valid MC addr: 224.0.0.0 - 239.255.255.255");

    int port = Int32.Parse(args[1]);  // Multicast port

    Socket sock = new Socket(AddressFamily.InterNetwork, SocketType.Dgram,
                             ProtocolType.Udp); // Multicast receiving socket

    // Set the reuse address option
    sock.SetSocketOption(SocketOptionLevel.Socket, 
                         SocketOptionName.ReuseAddress, 1);

    // Create an IPEndPoint and bind to it
    IPEndPoint ipep = new IPEndPoint(IPAddress.Any, port);
    sock.Bind(ipep);
    
    // Add membership in the multicast group
    sock.SetSocketOption(SocketOptionLevel.IP, 
                         SocketOptionName.AddMembership, 
                         new MulticastOption(address, IPAddress.Any));

    IPEndPoint receivePoint = new IPEndPoint(IPAddress.Any, 0);
    EndPoint tempReceivePoint = (EndPoint)receivePoint;
       
    // Create and receive a datagram
    byte[] packet = new byte[ItemQuoteTextConst.MAX_WIRE_LENGTH];
    int length = sock.ReceiveFrom(packet, 0, ItemQuoteTextConst.MAX_WIRE_LENGTH, 
                                  SocketFlags.None, ref tempReceivePoint);

    ItemQuoteDecoderText decoder = new ItemQuoteDecoderText();  // Text decoding
    ItemQuote quote = decoder.decode(packet);
    Console.WriteLine(quote);

    // Drop membership in the multicast group
    sock.SetSocketOption(SocketOptionLevel.IP, 
                         SocketOptionName.DropMembership, 
                         new MulticastOption(address, IPAddress.Any));
    sock.Close();
  }
}
