using System;              // For String, Int32, Console, ArgumentException
using System.Text;         // For Encoding
using System.IO;           // For IOException
using System.Net.Sockets;  // For Socket, SocketException
using System.Net;          // For IPAddress, IPEndPoint
using System.Threading;    // For Thread.Sleep

class TcpEchoPeekClient {

  static void Main(string[] args) {

    if ((args.Length < 2) || (args.Length > 3)) { // Test for correct # of args
      throw new ArgumentException("Parameters: <Server> <Word> [<Port>]");
    }

    String server = args[0];     // Server name or IP address

    // Convert input String to bytes 
    byte[] byteBuffer = Encoding.ASCII.GetBytes(args[1]);

    // Use port argument if supplied, otherwise default to 7
    int servPort = (args.Length == 3) ? Int32.Parse(args[2]) : 7;

    Socket sock = null;

    try {
      // Create a TCP socket instance 
      sock = new Socket(AddressFamily.InterNetwork, SocketType.Stream,
                        ProtocolType.Tcp);
     
      // Creates server IPEndPoint instance. We assume Resolve returns at least one address
      IPEndPoint serverEndPoint = new IPEndPoint(Dns.Resolve(server).AddressList[0], 
                                                 servPort);

      // Connect the socket to server on specified port
      sock.Connect(serverEndPoint);
      Console.WriteLine("Connected to server... sending echo string");
    
      // Send the encoded string to the server
      sock.Send(byteBuffer, 0, byteBuffer.Length, SocketFlags.None);

      Console.WriteLine("Sent {0} bytes to server...", byteBuffer.Length);

      int totalBytesRcvd = 0;   // Total bytes received so far
      int bytesRcvd = 0;        // Bytes received in last read

      // Receive the same string back from the server
      while (totalBytesRcvd < byteBuffer.Length) {

        // Peek at the data:
        bytesRcvd = sock.Receive(byteBuffer, totalBytesRcvd, 
                          byteBuffer.Length - totalBytesRcvd, SocketFlags.Peek);
        Console.WriteLine("Peeked at response, {0} bytes from server: {1}", bytesRcvd, 
                        Encoding.ASCII.GetString(byteBuffer, totalBytesRcvd, bytesRcvd));

        Console.WriteLine("Now reading the response...");
        if ((bytesRcvd = sock.Receive(byteBuffer, totalBytesRcvd, 
              byteBuffer.Length - totalBytesRcvd, SocketFlags.None)) == 0) {
           Console.WriteLine("Connection closed prematurely.");
           break;
        }
        totalBytesRcvd += bytesRcvd;
      }

      Console.WriteLine("Received {0} bytes from server: {1}", totalBytesRcvd, 
                        Encoding.ASCII.GetString(byteBuffer, 0, totalBytesRcvd));

    } catch (Exception e) {
       Console.WriteLine(e.Message);
    } finally {
      sock.Close();
    }
  }
}
