﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace DijekstraAlgorithm
{
    class PathGraph
    {
        private const int max_verts = 20; //line 10
        int infinity = 1000000;           //line 11
        int current;                      //line 12
        Vertex[] vertexList;              //line 13
        int[,] adjMat;                    //line 14
        int nVerts;                       //line 15
        int[] distance;                   //line 16
        public PathGraph()                //line 17
        {
           distance = new int [max_verts];
           vertexList = new Vertex[max_verts ];
           adjMat = new int [max_verts, max_verts];
           nVerts = 0;
           for(int j = 0; j < max_verts; j++)
                   for(int k = 0; k < max_verts; k++)
                         adjMat[j,k] = infinity;
        }                                //line 26
        //***********
        public void AddVertex(string lab)         //line 28
        {
             vertexList[nVerts] = new Vertex(lab);
             nVerts++;
        }                                        //line 32
        //***********                            //line 33
        public void AddEdge(int start, int theEnd, int weight)
        {
             adjMat[start, theEnd] = weight;
        }                                        //line 37
        //***********
        public int shortestPath(int s, int t)    //line 39
        {
            int smallDistance, newDistance, dc, k = 0;  //line 41
            for (int i = 0; i < nVerts; i++)      //line 42
            {
                vertexList[i].IsInTree = false;
                distance[i] = infinity;
            }                                     //line 46
            vertexList[s].IsInTree = true;        //line 47
            distance[s] = 0;                      //line 48
            current = s;                          //line 49
            while (current != t)                  //line 50
            {
                smallDistance = infinity;         //line 52
                dc = distance[current];           //line 53
                for (int i = 0; i < nVerts; i++)   //line 54
                    if (vertexList[i].IsInTree == false)
                    {
                        newDistance = dc + adjMat[current, i];
                        if (newDistance < distance [i])
                            distance [i] = newDistance ;
                        //Determine the new instance
                        if (distance[i] < smallDistance)
                        {
                            smallDistance = distance[i];
                            k = i;                   //line 64
                        }
                    }//end of for, if               //line 66
                vertexList[k].IsInTree = true;      //line 67
                current = k;                        //line 68
            }//end of while                 //line 69
            return distance[t];            //line 70
        }//end of shortest path           //line 71
        //***********************
        public void DidplayPath()         //line 73
        {
            for (int i = 0; i < nVerts; i++)
            {
                Console.Write("Shortest path from v0 to " +
                                vertexList[i].Label + " = ");
                Console.WriteLine(distance[i]);
            }
        }//end of DisplayPath           //line 81
    }//end of class                     //line 82
}
