﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace AdjacyMatrix
{
    class MatGraph
    {
        private const int NUM_VERTICES = 20;
        private MatVertex[] vertices;
        private int[,] adjMatrix;
        int numVerts;
        public MatGraph()
        {
            vertices = new MatVertex[NUM_VERTICES];
            adjMatrix = new int[NUM_VERTICES, NUM_VERTICES];
            numVerts = 0;
            for (int i = 0; i < NUM_VERTICES; i++)
                for (int j = 0; j < NUM_VERTICES - 1; j++)
                    adjMatrix[i, j] = 0;
        }
        //*********************
        public void AddVertex(string label)
        {
            vertices[numVerts] = new MatVertex(label);
            numVerts++;
        }
        //*****************
        public void AddEdge(int start, int eend)
        {
            adjMatrix[start, eend] = 1;
            adjMatrix[eend, start] = 1;
        }
        //*******************
        public void ShowAllVertex()
        {
            for (int i = 0; i < numVerts; i++)
                Console.Write("{0}  ", vertices[i].Label);
        }
        //******************
        public void ShowVertex(int v)
        {
            Console.Write(vertices[v].Label + " ");
        }
        //*******************
        public void ShowGraph()
        {
            for (int i = 0; i < numVerts; i++)
            {
                for (int j = 0; j < numVerts; j++)
                    Console.Write("{0} ", adjMatrix[i, j]);
                Console.WriteLine();
            }
        }//end of ShowGraph
    }
}
