﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Collections;
namespace Example3_3
{
    class Program
    {
        static void Main(string[] args)
        {
            string infix, postfix = "";                 //line 12
            Console.WriteLine(" Enter an infix expression :");
            infix = Console.ReadLine();                 //line 14
            convertToPostfix(infix, postfix);           //line 15
            Console.Read();
        }
        //******************
        static void convertToPostfix(string infix, string postfix) //line 19
        {
            string symbol, topSymbol;
            Stack oprStack = new Stack ();
            postfix = "";
            for (int p = 0; p < infix.Length; p++)                 //line 24
            {
                symbol = infix.Substring(p, 1);                    //line 26
                if (isNumeric(symbol)) //if operand, add to infix    line 27 
                    postfix += symbol;
                else if (symbol == "(")  //if "(", add to stack      line 29
                    oprStack.Push(symbol);                         //line 30
                else if (symbol == ")" ) //if ")", pop all op from stak, add to postfix
                {
                    topSymbol = (string)oprStack.Pop();             //line 33
                    while (topSymbol != "(")                       //line 34
                    {
                        postfix += topSymbol;
                        topSymbol = (string)oprStack.Pop();
                    }//end of while                                //line 38
                }//end of else if                                  //line 39
                else    //an operator                              //line 40
                {
                    //if stack empty or op1 in stack > incomming op //line 42
                    if (oprStack.Count == 0 || (!pred((string)oprStack .Peek (), symbol)))
                        oprStack.Push(symbol);
                    else    //compare incomming op with op in stack //line 45
                    {
                        topSymbol = (string)oprStack.Pop();        //line 47
                        while (pred(topSymbol, symbol))           //line 48
                        {
                            postfix += topSymbol;          //add topSymbol to postfix
                            if (oprStack.Count == 0)
                                break;
                            topSymbol = (string)oprStack.Pop();
                        } //end of while                          line 54
                        oprStack.Push(symbol);                    //line 55
                     }//end of else compare
                  }//end of else                              //line 57
                }//end of for                                 //line 59
                while (oprStack.Count > 0)                    //line 60
                {
                    topSymbol = (string)oprStack.Pop();
                    postfix += topSymbol;
                }//end while                                  //line 64
                Console.WriteLine("postfix expression is : " + postfix);
        }//end of convertToPostfix                       //line 66
        //****************************
        //if s is a number, reurn true
        static bool isNumeric(string s)                  //line 69
        {
            if (s.CompareTo ("0") >= 0 && s.CompareTo ("9") <= 0)
                return true;
            return false;
        }//end of isNumeric                              //line 75
        //if op1 > op2 return true
        static bool pred(string op1, string op2)         //line 77
        {
            int p1, p2;
            string opString = "(+-*/%";  //valid operators
            int[] isp = { 0, 12, 12, 13, 13, 13 }; //precedence of operators in stack
            p1 = opString.IndexOf(op1);   //find the index of op1 in opString
            p2 = opString.IndexOf(op2);   //find the index of op2 in opString
            if (isp[p1] >= isp[p2])
                return true;
            return false;
        }                                               //line 87
    }
}
