﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace IteratorClass
{
    class Program
    {
        static void Main(string[] args)
        {
            NewLinkedList MyList = new NewLinkedList();
            IteratorList iter = new IteratorList(MyList);
            string choice, value;
            try
            {
                iter.InsertAfter("100");
                iter.InsertAfter("200");
                iter.InsertAfter("300");
                iter.InsertAfter("400");
                iter.InsertAfter("500");
                iter.InsertBefore("600");
                iter.InsertAfter("700");
                iter.InsertBefore("800");
                iter.InsertBefore("900");
                iter.InsertBefore("1000");
                while (true)
                {
                    Console.WriteLine("(n) Move to next node");
                    Console.WriteLine("(g) Get value in current node");
                    Console.WriteLine("(r) Reset iterator");
                    Console.WriteLine("(s) Show complete list");
                    Console.WriteLine("(a) Insert after");
                    Console.WriteLine("(b) Insert before");
                    Console.WriteLine("(x) Exit");
                    Console.WriteLine();
                    Console.Write("Enter your choice: ");
                    choice = Console.ReadLine();
                    choice = choice.ToLower();
                    char[] onechar = choice.ToCharArray();
                    switch (onechar[0])
                    {
                        case 'n':
                            if (!(MyList.IsEmpty()) && (!(iter.AtEnd())))
                                iter.NextLink();
                            else
                                Console.WriteLine("Can' move to next link.");
                            break;
                        case 'g':
                            if (!(MyList.IsEmpty()))
                                Console.WriteLine("Element: " + iter.GetCurrent().Data);
                            else
                                Console.WriteLine("List is empty.");
                            break;
                        case 'r':
                            iter.Reset();
                            break;
                        case 's':
                            if (!(MyList.IsEmpty()))
                                MyList.ShowList();
                            else
                                Console.WriteLine("List is empty.");
                            break;
                        case 'a':
                            Console.WriteLine();
                            Console.Write("Enter value to insert:");
                            value = Console.ReadLine();
                            iter.InsertAfter(value);
                            break;
                        case 'b':
                            Console.WriteLine();
                            Console.Write("Enter value to insert:");
                            value = Console.ReadLine();
                            iter.InsertBefore(value);
                            break;
                        case 'x':
                            Environment.Exit(0);
                            // end of program
                            break;
                    }//end of switch
                }//end of while
            }//end of try
            catch (InsertBeforeHeaderException e)
            {
                Console.WriteLine(e.Message);
            }//end of catch
        }//end of Main
    }
}
