﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace ConsoleApplication1
{
    class CLinkedList
    {
        protected CNode header;
        public CLinkedList()
        {
            header = new CNode("0");
            header.Link = header;
        }
        //******************
        public bool IsEmpty()
        {
            return (header.Link == null);
        }
        //********************
        public void MakeEmpty()
        {
            header.Link = null;
        }
        //******************
        public void PrintList()
        {
            CNode current = new CNode();
            if (!IsEmpty())
            {
                current = header;
                do
                {
                    Console.Write("{0} {1}", current.Link.Data, " ");
                    current = current.Link;
                } while (current.Link != header);
            }
            Console.WriteLine("\nCount  = " + header.Data);
        }
        //********************
        private CNode FindPrevious(Object n)
        {
            CNode current = header;
            while (!(current.Link == null) && current.Link.Data != n)
                current = current.Link;
            return current;
        }
        //*******************************
        private CNode Find(Object n)
        {
            CNode current = new CNode();
            current = header.Link;
            while (current.Data != n)
                current = current.Link;
            return current;
        }
        //***********************
        public void Remove(Object n)
        {
           CNode p = FindPrevious(n);
           if (!(p.Link == null))
           {
               p.Link = p.Link.Link;
               header.Data = (Object)(Convert.ToInt32(header.Data) - 1);
           }
        }
        //************************
        public void Insert(Object n1, Object n2)
        {
           CNode current = new CNode();
           CNode newnode = new CNode(n1);
           current = Find(n2);
           newnode.Link = current.Link;
           current.Link = newnode;
           header.Data = (Object)(Convert.ToInt32(header.Data) + 1);

        }
        //**************************
        public void InsertAtFirst(Object n)
        {
           CNode current = new CNode(n);
           current.Link = header;
           header.Link = current;
           header.Data = (Object)(Convert.ToInt32(header.Data) + 1);
        }
    }
}
