
// Declare timeout variable
var pageTimeout

// Number of milliseconds to display each page
// This can be overridden by the user
var displayTime = 5000

// Is autobrowsing on by default?
var autoBrowsingOn = true

// Index within pageSequence of next page to load
var nextIndex = 0

window.onload = setupAutoBrowse

// Get any stored settings and set page timeout
function setupAutoBrowse() {
 // Load current settings from cookie
 autoBrowseCookie = getCookie("autobrowse")
 if(autoBrowseCookie == "true") autoBrowsingOn = true
 else if(autoBrowseCookie == "false") autoBrowsingOn = false
 timeoutCookie = getCookie("timeout")
 if(timeoutCookie != null) displayTime = parseInt(timeoutCookie)
 // Determine which page is the current page
 var currentURL = window.location.href
 var currentIndex = -1
 for(var i=0; i<pageSequence.length; ++i) {
  if(currentURL.indexOf(pageSequence[i]) != -1) {
   currentIndex = i
   break
  }
 }
 // Determine which page is the next page
 nextIndex = (currentIndex + 1) % pageSequence.length
 // Set a timeout to load the next page
 if(autoBrowsingOn) setPageTimeout()
}

// Function to load the next page
function loadNextPage() {
 window.location.href = pageSequence[nextIndex]
}

// Set the page timeout
function setPageTimeout() {
 pageTimeout = window.setTimeout("loadNextPage()", displayTime)
}

// Allow the user to cancel the timeout
function cancelPageTimeout() {
 window.clearTimeout(pageTimeout)
}

function getCookie(name) {
 var cookie = removeBlanks(document.cookie)
 var nameValuePairs = cookie.split(";")
 for(var i=0; i<nameValuePairs.length; ++i) {
  var pairSplit = nameValuePairs[i].split("=")
  if(pairSplit[0] == name && pairSplit.length > 1) return pairSplit[1]
 }
 return null
}

function setCookie(name, value, expirationDate) {
 document.cookie = name+"="+value
}

function removeBlanks(s) {
 var temp = ""
 for(var i=0; i<s.length; ++i) {
  var c = s.charAt(i)
  if(c != " ") temp += c
 }
 return temp
}

function insertAutoBrowserControl() {
 document.writeln('<FORM name="autobrowseform">')
 document.writeln('<B>AutoBrowsing: </B>')
 document.writeln('<SELECT name="autobrowseselect" size="1" onChange="updateAutoBrowsing()">')
 document.writeln('<option value="-1"></option>')
 document.writeln('<option value="5">Display a new page every 5 seconds</option>')
 document.writeln('<option value="10">Display a new page every 10 seconds</option>')
 document.writeln('<option value="30">Display a new page every 30 seconds</option>')
 document.writeln('<option value="60">Display a new page every minute</option>')
 document.writeln('<option value="120">Display a new page every 2 minutes</option>')
 document.writeln('<option value="300">Display a new page every 5 minutes</option>')
 document.writeln('<option value="0">Turn off autobrowsing</option>')
 document.writeln('</SELECT>')
 document.writeln('</FORM>')
}

function updateAutoBrowsing() {
 var selections = window.document.forms["autobrowseform"].elements["autobrowseselect"].options
 for(var i=0; i<selections.length; ++i) {
  if(selections[i].selected) {
   var v = selections[i].value
   if(v == -1) break
   cancelPageTimeout()
   if(v == 0) {
    autoBrowsingOn = false
   }else {
    autoBrowsingOn = true
    displayTime = v * 1000
    setPageTimeout()
   }
   setCookie("autobrowse", autoBrowsingOn)
   setCookie("timeout", displayTime)
   break
  }
 }
}
