// menu.js

// The MenuBar object

function MenuBar(reference, menuwidth) {
 this.reference = reference
 this.menuwidth = menuwidth
 this.menus = null
 this.menuClicked = -1
 this.browser = "unknown"
 if(navigator.appName == "Microsoft Internet Explorer" && 
   parseInt(navigator.appVersion) >= 4) this.browser = "ie4"
 else if(navigator.appName == "Netscape" && parseInt(navigator.appVersion) >= 4 &&
   parseInt(navigator.appVersion) < 5) this.browser = "nav4"
 else if(navigator.appName == "Netscape" && 
   parseInt(navigator.appVersion) >= 5) this.browser = "nav6"

 this.addMenu = MenuBar_addMenu
 this.handleClick = MenuBar_handleClick
 this.hideMenu = MenuBar_hideMenu
 this.display = MenuBar_display
 this.displayIE4 = MenuBar_displayIE4
 this.displayNav4 = MenuBar_displayNav4
 this.displayNav6 = MenuBar_displayNav6
 this.showMenu = MenuBar_showMenu
 this.showMenuIE4 = MenuBar_showMenuIE4
 this.showMenuNav4 = MenuBar_showMenuNav4
 this.showMenuNav6 = MenuBar_showMenuNav6
}

function MenuBar_addMenu(menu) {
 if(this.menus == null) {
  this.menus = new Array(1)
  this.menus[0] = menu
 }else{
  var n = this.menus.length
  this.menus[n] = menu
 }
}

function MenuBar_handleClick(n) {
 if(this.menuClicked >= 0) {
  if(n == this.menuClicked) {
   this.hideMenu(n)
   this.menuClicked = -1
  }else{
   this.hideMenu(this.menuClicked)
   this.showMenu(n)
   this.menuClicked = n
  }
 }else{
  this.showMenu(n)
  this.menuClicked = n
 }
}

function MenuBar_hideMenu(n) {
 var menuItemDiv
 if(this.browser == "ie4") {
  menuItemDiv = document.all(this.reference+"."+n+".mi",0)
  menuItemDiv.style.visibility = "hidden"
 }else if(this.browser == "nav4") {
  menuItemDiv = document.layers[this.reference+"."+n+".mi"]
  menuItemDiv.visibility = "hidden"
 }else if(this.browser == "nav6") {
  menuItemDiv = document.getElementById(this.reference+"."+n+".mi")
  menuItemDiv.style.zIndex = -100
  menuItemDiv.style.visibility = "hidden"
 }  
}

function MenuBar_showMenu(n) {
 if(this.browser == "ie4") this.showMenuIE4(n)
 else if(this.browser == "nav4") this.showMenuNav4(n)
 else if(this.browser == "nav6") this.showMenuNav6(n) 
}

function MenuBar_showMenuIE4(n) {
 var menuBarDiv = document.all(this.reference,0)
 var menuDiv = document.all(this.reference+"."+n,0)
 var menuItemDiv = document.all(this.reference+"."+n+".mi",0)
 var menuBarX = menuBarDiv.offsetLeft
 var menuBarY = menuBarDiv.offsetTop
 var menuBarWidth = menuBarDiv.offsetWidth
 var menuBarHeight = menuBarDiv.offsetHeight
 var delta = 0
 for(var i=0; i<n; ++i) {
  var tempDiv = document.all(this.reference+"."+i,0)
  delta += tempDiv.offsetWidth + 6
 }
 menuItemDiv.style.left = menuBarX + delta
 menuItemDiv.style.top = menuBarY + menuBarHeight
 menuItemDiv.style.visibility = "visible"
}

function MenuBar_showMenuNav4(n) {
 var menuBarDiv = document.layers[this.reference]
 var menuItemDiv = document.layers[this.reference+"."+n+".mi"]
 var menuBarX = menuBarDiv.pageX
 var menuBarY = menuBarDiv.pageY
 var menuWidth = menuBarDiv.clip.width
 var menuHeight = menuBarDiv.clip.height
 var avgWidth = (n*(menuWidth/this.menus.length))
 menuItemDiv.pageX = menuBarX+avgWidth
 menuItemDiv.pageY = menuBarY+menuHeight
 menuItemDiv.visibility = "visible"
}

function MenuBar_showMenuNav6(n) {
 var menuBarDiv = document.getElementById(this.reference)
 var menuDiv = document.getElementById(this.reference+"."+n)
 var menuItemDiv = document.getElementById(this.reference+"."+n+".mi")
 var menuBarX = parseInt(menuBarDiv.style.left)
 var menuBarY = parseInt(menuBarDiv.style.top)
 var menuBarWidth = parseInt(menuBarDiv.style.marginTop)
 var menuBarHeight = parseInt(menuBarDiv.style.marginRight)
 var delta = this.menuwidth + 2
 if(delta == 2) delta = 75
 delta *= n
 menuItemDiv.style.left = menuBarX + delta + "px"
 menuItemDiv.style.top = menuBarY + 35 + "px"
 menuItemDiv.style.zIndex = 100
 menuItemDiv.style.visibility = "visible"
}

function MenuBar_display(x, y) {
 if(this.browser == "ie4") this.displayIE4(x,y)
 else if(this.browser == "nav4") this.displayNav4(x,y)
 else if(this.browser == "nav6") this.displayNav6(x,y)
}

function MenuBar_displayIE4(x,y) {
 var styleString = 'position: absolute; left: '+x+'; top: '+y
 document.writeln('<div id="'+this.reference+'" style="'+styleString+'">')
 document.write('<table border="1"><colgroup span="'+this.menus.length)
 document.writeln('" width="'+this.menuwidth+'"><tr>')
 for(var i=0; i<this.menus.length; ++i)
  this.menus[i].displayIE4(this.reference,i)
 document.writeln('</tr></table>')
 document.writeln('</div>')
 for(var i=0; i<this.menus.length; ++i)
  this.menus[i].displayMenuItemsIE4(this.reference,i)
}

function MenuBar_displayNav4(x,y) {
 var styleString = 'position: absolute; left: '+x+'; top: '+y
 document.writeln('<layer id="'+this.reference+'" pagex="'+x+'" pagey="'+y+'">')
 document.writeln('<table border="1"><tr>')
 for(var i=0; i<this.menus.length; ++i)
  this.menus[i].displayNav4(this.reference,i)
 document.writeln('</tr></table>')
 document.writeln('</layer>')
 for(var i=0; i<this.menus.length; ++i)
  this.menus[i].displayMenuItemsNav4(this.reference,i)
}

function MenuBar_displayNav6(x,y) {
 for(var i=0; i<this.menus.length; ++i)
  this.menus[i].displayMenuItemsNav6(this.reference,i)
 var styleString = 'position: absolute; left: '+x+'; top: '+y
 document.writeln('<div id="'+this.reference+'" style="'+styleString+'">')
 document.write('<table border="1"><colgroup span="'+this.menus.length)
 document.writeln('" width="'+this.menuwidth+'"><tr>')
 for(var i=0; i<this.menus.length; ++i)
  this.menus[i].displayNav6(this.reference,i)
 document.writeln('</tr></table>')
 document.writeln('</div>')
}

// The Menu object

function Menu(name, backgroundColor, textColor) {
 if(arguments.length < 3) textColor = "black"
 if(arguments.length < 2) backgroundColor = "white"
 this.name = name
 this.backgroundColor = backgroundColor
 this.textColor = textColor
 this.menuItems = null

 this.addMenuItem = Menu_addMenuItem
 this.displayIE4 = Menu_displayIE4
 this.displayNav4 = Menu_displayNav4
 this.displayNav6 = Menu_displayNav6
 this.displayMenuItemsIE4 = Menu_displayMenuItemsIE4
 this.displayMenuItemsNav4 = Menu_displayMenuItemsNav4
 this.displayMenuItemsNav6 = Menu_displayMenuItemsNav6
}

function Menu_addMenuItem(name, action) {
 var menuItem = new MenuItem(name, action)
 if(this.menuItems == null) {
  this.menuItems = new Array(1)
  this.menuItems[0] = menuItem
 }else{
  var n = this.menuItems.length
  this.menuItems[n] = menuItem
 } 
}

function Menu_displayIE4(reference, menuNumber) {
 document.writeln('<th>')
 var id = ""+reference + "." + menuNumber
 document.write('<div id="'+id+'" onclick="'+reference+'.handleClick('+menuNumber+')"')
 document.write(' style="padding: 2; background-color: '+this.backgroundColor+'; color: ')
 document.writeln(this.textColor+'">')
 var styleString = "text-decoration: none; color: "+this.textColor
 document.writeln('<a href="javascript:void(0)" style="'+styleString+'">'+this.name+'</a>')
 document.writeln('</div></th>')
}

function Menu_displayMenuItemsIE4(reference, menuNumber) {
 var id = ""+reference + "." + menuNumber + ".mi"
 var style="position: absolute; left: 10; top:10; visibility: hidden"
 document.write('<div id="'+id+'" style="'+style+'">')
 document.write('<table border="1">')
 for(var i=0; i<this.menuItems.length; ++i) {
  document.write('<tr><td bgcolor="'+this.backgroundColor+'">')
  var styleString = "font-weight: bold; text-decoration: none; color: "+this.textColor
  document.write('<a href="javascript:'+reference+'.handleClick('+menuNumber+');')
  document.writeln(this.menuItems[i].action+'" style="'+styleString+'">')
  document.writeln(this.menuItems[i].name+'</a>')
  document.write('</td></tr>')
 }
 document.writeln('</table></div>')
}

function Menu_displayNav4(reference, menuNumber) {
 document.writeln('<th bgcolor="'+this.backgroundColor+'">')
 var anchorStart = '<a href="javascript:void(0)" '
 anchorStart += 'onclick="window.'+reference+'.handleClick('+menuNumber+')">'
 anchorStart += '<font color="'+this.textColor+'">'
 document.writeln(anchorStart+this.name+'</a>')
 document.writeln('</font></th>')
}

function Menu_displayMenuItemsNav4(reference, menuNumber) {
 var id = ""+reference + "." + menuNumber + ".mi"
 document.write('<layer id="'+id+'" pagex="10 pagey="10"')
 document.write(' visibility="hidden"><table border="1">')
 for(var i=0; i<this.menuItems.length; ++i) {
  document.write('<tr><td bgcolor="'+this.backgroundColor+'">')
  document.write('<a href="javascript:'+reference+'.handleClick('+menuNumber+');')
  document.writeln(this.menuItems[i].action+'"><font color="'+this.textColor+'"><b>')
  document.writeln(this.menuItems[i].name+'</b></font></a>')
  document.write('</td></tr>')
 }
 document.writeln('</table></layer>')
}

function Menu_displayNav6(reference, menuNumber) {
 document.writeln('<th>')
 var id = ""+reference + "." + menuNumber
 document.write('<div id="'+id+'" onclick="'+reference+'.handleClick('+menuNumber+')"')
 document.write(' style="padding: 2; background-color: '+this.backgroundColor+'; color: ')
 document.writeln(this.textColor+'">')
 var styleString = "text-decoration: none; color: "+this.textColor
 document.writeln('<a href="javascript:void(0)" style="'+styleString+'">'+this.name+'</a>')
 document.writeln('</div></th>')
}

function Menu_displayMenuItemsNav6(reference, menuNumber) {
 var id = ""+reference + "." + menuNumber + ".mi"
 var style="position: absolute; left: 10; top:10; visibility: hidden"
 document.write('<div id="'+id+'" style="'+style+'">')
 document.write('<table border="1">')
 for(var i=0; i<this.menuItems.length; ++i) {
  document.write('<tr><td bgcolor="'+this.backgroundColor+'">')
  var styleString = "font-weight: bold; text-decoration: none; color: "+this.textColor
  document.write('<a href="javascript:'+reference+'.handleClick('+menuNumber+');')
  document.writeln(this.menuItems[i].action+'" style="'+styleString+'">')
  document.writeln(this.menuItems[i].name+'</a>')
  document.write('</td></tr>')
 }
 document.writeln('</table></div>')
}

// The MenuItem object

function MenuItem(name, action) {
 this.name = name
 this.action = action
}

