program data;
uses crt;
const M = 20;
type
     binPtr = ^binNode;
     binNode = record
       left   : binPtr;
       right  : binPtr;
       father : binptr;
       freq   : integer ;
       sym    : char;
     end;
     qPtr = ^queue;
     queue = record
         next : qPtr;
         info : integer;
         sym  : char;
     end;
     stack = record
         myTop : integer;
         item  : array[0..M - 1] of binPtr;
     end;
var
     root : binPtr;
     symbol1, symbol2 : char;
     n, fr, x, y, i : integer;
     pq : qPtr;
{*************}
procedure pqInsert(var pq : qPtr; num : integer; symbol : char);
var
     q, h, p : qPtr;
begin
     new(q);
     q ^. next := nil;
     q ^. info := num;
     q ^. sym := symbol;
     p := pq;
     h := pq ^. next;
    while h <> nil do
    begin
	    if q ^. info > h ^. info then
	     begin
		p := h;
		h := h ^. next;
	     end
	     else
		break;
    end;{end of while}
    q ^. next := h;
    p ^. next := q;
    pq ^. info := (pq ^. info) + 1;
end;
{****************}
procedure qremove(var pq : qPtr; var num : integer; var symbol : char);
var
   p : qPtr;
begin
   if pq ^. info > 0 then
   begin
      pq ^. info := (pq ^. info) - 1;
      p := pq ^. next;
      num := pq ^. next ^. info;
      symbol := pq ^. next ^. sym;
      pq ^. next := p ^.next;
      dispose(p);
   end;
end;
{*******************}
procedure maketree(var root:binPtr; x : integer; y : integer; symbol1 : char; symbol2 : char);
var
   p1, p2, p : binPtr;
begin
   new(p1);
   new(p2);
   new(p);
   p ^.  freq := x + y;
   p1 ^. freq := x;
   p1 ^. sym := symbol1;
   p1 ^. left := nil;
   p1 ^. right := nil;
   p2 ^. freq := y;
   p2 ^. sym := symbol2;
   p2 ^. left := nil;
   p2 ^. right := nil;
   p ^.  left := p1;
   p ^.  right := p2;
   p ^.  father := nil;
   p1 ^. father := p;
   p2 ^. father := p;
   if root = nil then
      root := p
   else
   begin
      if p1 ^. freq = root ^. freq then
      begin
	 p1 ^. left := root ^. left;
	 p1 ^. right := root ^. right;
	 p1 ^. left ^. father := p1;
         p1 ^. right ^. father := p1;
	 dispose(root);
	 root := p;
      end
      else
      begin
	 p2 ^. left := root ^. left;
	 p2 ^. right := root ^. right;
	 p2 ^. left ^. father := p2;
         p2 ^. right ^. father := p2;
	 dispose(root);
	 root := p;
      end;
   end;
end;
{***************}
function empty(s : stack) : boolean;
begin
   empty := false;
   if s.myTop = -1 then
      empty := true;
end;
{****************}
procedure printCode(tree : binPtr);
var
     code : array[0..M - 1] of integer;
     k, j : integer;
     p1, q, p : binPtr;
     s : stack;
begin
  p := tree;
  s.myTop := -1;
  writeln('Generated code is:');
  repeat
     { travel down left branches as far as possible
      saving pointers to nodes passed}
     while p <> nil do
     begin
         s.myTop := (s.myTop) + 1;
	 s.item[s.myTop] := p; {push to stack}
	 p := p ^. left;
     end;
     { check if finished}
     if  (not empty(s)) then
     begin
         {at this point the left subtree is empty}
	 p := s.item[(s.myTop)];  {pop from stack}
         s.myTop := (s.myTop) - 1;
	 if p ^. right = nil then  {p is leaf}
	 begin      {traverae tree up to generate code}
		  k := M - 1;
		  p1 := p;
		  while p1 <>  nil do
		  begin
		       q := p1 ^. father;
		       if q ^. left = p1 then
                       begin
				code[k] := 1;
                                k := k - 1;
                        end
			else
                        begin
				code[k] := 0;
                                k := k - 1;
                        end;
			p1 := q;
		   end; {while}
		   write(p ^. sym, '=');
		   for j := k + 2 to M - 1 do
			write(code[j]);
		   writeln;
	 end;
	 p := p ^. right;   {traverse right subtree}
     end;
  until (empty(s)) and (p = nil);
end; {end of printCode}
{**************}
begin
   root := nil;
   clrscr;
   {create head node}
   new(pq);
   pq ^. next := nil;
   pq ^. info := 0;
   write('Enter number of symbols:');
   readln(n);
   for i := 0 to n - 1 do
   begin
      write('Enter symbol, frequency:');
      readln(symbol1, fr);
      pqInsert(pq, fr, symbol1);
   end;
   while pq ^. info > 1 do
   begin
       qremove(pq, x, symbol1);
       qremove(pq, y, symbol2);
       maketree(root, x, y, symbol1, symbol2);
       pqInsert(pq, x + y, '*');
   end;
   printCode(root);
   readln;
end.
