program data;
uses crt;
const  M = 21;
type treePtr = ^tree;
     tree = record
         info  : char;
         left  : treePtr;
         right : treePtr;
     end;
     stack = record
        myTop : integer;
        items : array [0..M - 1] of treePtr;
     end;
var
      postfix : string;
{*****************}
function isOperand(symbol : char) : boolean;
begin
   isOperand := false;
   if  (symbol >= '0') and (symbol <= '9') then
      isOperand := true;
end;
{*******************}
procedure push(var s : stack; var x : treePtr);
begin
       s.myTop := s.myTop + 1;
       s.items[s.myTop] := x;
end;
{*******************}
procedure  pop(var s : stack; var x : treePtr);
begin
     x := s.items[s.myTop];
     s.myTop := s.myTop - 1;
end;
{*****************}
procedure inorder(s : treePtr);
begin
  if s <> nil then
  begin
     inorder(s ^. left);
     write(s ^. info, ' ');
     inorder(s ^. right);
  end;
end;
{******************}
procedure make(postfix : string);
var
    newPtr, ptr1, ptr2 : treePtr;
    symbol : char;
    s : stack;
    i : integer;
begin
    new(ptr1);
    new(ptr2);
    s.myTop := -1;
    for i := 1 to length(postfix) do
    begin
       symbol := postfix[i];
       if isOperand(symbol) then
       begin
	   new(newPtr);
	   newPtr ^. info := symbol;
	   newPtr ^. left := nil;
           newPtr ^. right := nil;
	   push(s, newPtr);
       end
       else
       begin
	   pop(s, ptr1);
	   pop(s, ptr2);
	   new(newPtr);
	   newPtr ^. info  := symbol;
	   newPtr ^. left  := ptr2;
	   newPtr ^. right := ptr1;
	   push(s, newPtr);
       end;{end of else}
    end;{ of for}
    writeln('Inorder traversal of constructed tree is:');
    inorder(s.items[s.myTop]);
end;
{******************}
begin
   clrscr;
   write('Enter a postfix expression:');
   readln(postfix);
   make(postfix);
   readln;
end.

