program data;
uses crt;
type
    treePtr = ^tree;
    tree = record
       left  : treePtr;
       key   : integer;
       bf    : integer;
       right : treePtr;
    end;
var
    h, root : treePtr;
    x, ub : integer;
{*****************}
procedure right_rotation(var parent : treePtr; ub : integer);
var
   grand_child, child : treePtr;
begin
   child := parent ^. left;
   if child ^. bf = 1 then
   begin
      {LL rotation}
      parent ^. left := child ^. right;
      child ^. right := parent;
      parent ^. bf := 0;
      parent := child;
   end
   else
   begin   {LR rotation}
      grand_child := child ^. right;
      child ^. right := grand_child ^. left;
      grand_child ^. left := child;
      parent ^. left := grand_child ^. right;
      case grand_child ^. bf of
	 1:
	     begin
               parent ^. bf := -1;
	       child ^. bf := 0;
	     end;
	 0:
             begin
	       parent ^. bf := 0;
               child ^. bf := 0;
	     end;
	 -1:
             begin
	       parent ^. bf := 0;
	       child ^. bf := 1;
             end;
      end; {case}
      parent := grand_child;
   end;{else}
   parent ^. bf := 0;
   ub := 0;
end;
{*****************}
procedure left_rotation(var parent : treePtr; ub : integer);
begin
end;
{*********************}
procedure avl_insert(var parent : treePtr; x : integer; var ub : integer);
begin
   if  parent = nil then
   begin     {insert element into null tree}
      ub := 1;
      new(parent);
      parent^. left := nil;
      parent ^. right := nil;
      parent^. bf := 0;
      parent^. key := x;
   end
   else if x < parent^.key then
   begin
       avl_insert(parent ^. left, x, ub);
       if ub <> 0 then  {left branch has grown higher}
	  case parent^.bf of
	     -1:
                begin
		   parent ^. bf := 0;
		   ub := 0;
		end;
	     0:
		parent ^. bf := 1;
	     1:
		right_rotation(parent, ub);
	  end;
   end{ of else if}
   else if x > parent ^. key then
   begin
       avl_insert(parent ^. right, x, ub);
       if ub <> 0  then
	  case parent ^. bf of
	     -1:
                begin
		  parent ^. bf := 0;
		  ub := 0;
		end;
	     0:
		parent ^. bf := -1;
	     1:
		left_rotation(parent, ub);
	  end;{end of case}
   end { of else if}
   else
   begin
      ub := 0;
      write('The key is already in the tree.');
      readln;
   end;
end;
{*****************}
procedure inorder (s : treePtr);
begin
    if s <> nil then
    begin
       inorder(s ^. left) ;
       write(s ^. key, ' ');
       inorder(s ^. right) ;
    end;
end;
{*****************}
begin
  root := nil;
  clrscr;
  while true do
  begin
      write('Enter a number:');
      readln(x);
      if x = 0 then
	 break;
      avl_insert(root, x, ub);
  end;
  writeln('Traverse of AVL tree is:');
  inorder(root);
  readln;
end.
