program data;
uses crt;
type
     threadPtr = ^threadNode;
     threadNode = record
         left : threadPtr;
         info : integer;
         rthread : boolean;
         right : threadPtr;
     end;
var
    start : threadPtr;
    num : integer;
{**********************}
function  menu_select : integer;
var
   choice : integer;
begin
   writeln('1- Enter a number in tree.');
   writeln('2- Search a number in tree.');
   writeln('3- Print information on screen.') ;
   writeln('4- Delete an item.');
   writeln('5- Quit from program.') ;
   write('Enter your select(1-5):');
   readln(choice);
   menu_select := choice;
end;
{**********************}
function  search(s : threadPtr; num : integer) : boolean;
var
   h : threadPtr;
begin
   search := false;
   h := s;
   while h <> nil do
   begin
      if  num < h ^. info then
	  h := h ^. left
      else if num > h ^.info then
	 h := h ^. right
      else
      begin
          search := true;
          break;
      end;
    end; {while}
end;
{********************}
procedure search2(var root : threadPtr; item : integer; var found : boolean;
	     var locptr : threadPtr; var parent : threadPtr);
begin
   locptr := root;
   parent := nil;
   found := false;
   while true do
   begin
       if(found) or (locptr = nil) then
	  exit;
       if item < locptr ^. info then    {descend left}
       begin
	  parent := locptr;
	  locptr := locptr ^. left;
       end
       else if item > locptr ^. info then {descend right}
       begin
	  parent := locptr;
	  locptr := locptr ^. right;
       end
       else
	  found := true;
   end;
end;
{***************}
function inpred(x : threadPtr) : threadPtr;
var
    pred : threadPtr;
begin
    pred := x ^. left;
    while pred ^. rthread = false do
       pred := pred ^. right;
    inpred := pred;
end;
{*********************}
procedure insucc(x : threadPtr; var parent : threadPtr; var succ : threadPtr);
begin
    succ := x ^. right;
    parent := x;
    if x ^. rthread = false then
       while succ ^. left <> nil do
       begin
	  parent := succ;
	  succ := succ ^. left;
       end;
end;
{*************************}
procedure  deleteNode(var  root : threadPtr; item : integer);
var
   found : boolean;
   x, parent, subtree, pred, succ : threadPtr;
begin
  search2(root, item, found, x, parent);
  if not found then
  begin
      write('item not found in BST.');
      exit;
  end;
  if (x ^. left <> nil) and (x ^. rthread = false) then
  begin    {node has two children
       Find x's successor and its parent
       Move contents of  x succ to x and change x
       to point to successor, wich will be deleted.}
       insucc(x, parent, succ);
       x ^. info := succ ^. info;
       x := succ;
  end;{end of if}
  {Now proceed with case where node has 0 or 1 child}
  if parent = nil then
  begin
      if x ^. left <> nil then
      begin
	   root := x ^. left;
	   pred := inpred(x);
	   pred ^. right := nil;
      end
      else
	   root := x ^. right;
      dispose(x);
      exit;
  end;
  if ((x ^. left = nil) and (x ^. rthread)) then {leaf}
  begin
      if parent ^. left = x then {left leaf}
      begin
	  parent ^. left := nil;
	  dispose(x);
      end
      else begin   {right leaf}
	  parent ^. rthread := true;
	  parent ^. right := x ^. right;
	  dispose(x);
     end;
  end
  else    { not leaf}
  begin
	if x ^. left <> nil then
	    subtree := x ^. left
	else
	    subtree := x ^. right;
	if parent ^. left = x then {left child}
		parent ^. left := subtree
	else                       {right child}
		parent ^. right := subtree;
	if (x ^. rthread = true) and (x ^. right <> nil) then
	begin
	      pred := inpred(x);
	      pred ^. right := parent;
	end
	else if(x ^. rthread = true) and (x ^. right = nil) then
	begin
	      pred := inpred(x);
	      pred ^. right := nil;
	      pred ^. rthread := true;
	end;
	dispose(x);
  end;
end; {end of deleteNode()}
{*****************}
procedure maketree(var root : threadPtr; num : integer);
var
   p, q, r : threadPtr;
begin
   new(q);
   q ^. left := nil;
   q ^. right := nil;
   q ^. info := num;
   q ^. rthread := true;
   if root = nil then
      root := q
    else
    begin
      p := root;
      while p <> nil do
      begin
	if q ^. info > p ^. info then
	begin
	    if p ^. rthread then
	    begin
		 p ^. rthread := false;
		 {save the inorder successor of node p}
		 r := p ^. right;
		 p ^. right := q;
		 q ^. left := nil;
		 {The inorder successor of node q is the}
		 {previous successor of node p}
		 q ^. right := r;
		 q ^. rthread := true;
		 break;
	    end{end of if}
	    else
	       p := p ^. right;
	end{end of if}
	else  begin
	    if p ^. left <> nil then
		   p := p ^. left
	    else  begin
		 p ^. left := q ;
		 q ^. left := nil;
		 {The inorder successor of node q is node p}
		 q ^. right := p;
		 q ^. rthread := true;
		 break ;
	    end; {end of else}
	end;  {end of else}
      end;{end of while}
   end;{end else}
end;
{*******************}
procedure input(var start : threadPtr);
var
    num : integer;
begin
    while true do
    begin
      write('Enter a number:');
      readln(num);
      if num = 0 then
	  break;
      maketree(start, num);
    end; {end while}
end;
{*******************}
procedure inorder(s : threadPtr);
var
   p, q : threadPtr;
begin
   writeln('Traverse of tree is :');
   p := s;
   repeat
      q := nil;
      while p <> nil do  {Traverse left branch}
      begin
	 q := p;
	 p := p ^. left;
      end; {end of while;}
      if q <> nil then
      begin
	 write(q ^. info, '  ');
	 p := q ^. right;
	 while (q ^. rthread) and (p <> nil) do
	 begin
	    write(p ^. info, '  ');
	    q := p;
	    p := p ^. right;
	 end;{end of while}
      end;{end of if}
   until q = nil;
end;
{*****************************}
begin
    start := nil;
    while true do
    begin
	clrscr;
	case menu_select of
	  1:
	      input(start) ;
	  2:
              begin
		 write('Enter number to search:');
		 readln(num);
		 if search(start, num) then
		    write('Number found.')
		 else
		    write('Number not found.');
		 readln ;
	      end;
	  3:
              begin
		 clrscr;
		 inorder(start) ;
		 readln;
	      end;
	  4:
              begin
          	 write('Enter number to delete:');
		 readln(num);
		 deleteNode(start, num);
	      end;
	  5:
              exit;
	end; {end of switch}
    end; {end of while}
end.{end of main}

