program data;
uses crt;
type
     treePtr = ^tree;
     tree = record
         left  : treePtr ;
         key   : integer;
         right : treePtr;
     end;
var
    start : treePtr;
    num   : integer;

{**********************}
procedure tinsert(var root :  treePtr; num : integer);
var
   node, help : treePtr;
begin
   help := root;
   new(node);
   node ^. left  := nil;
   node ^. right := nil;
   node ^. key := num;
   if root = nil then
      root := node
   else
   begin
      while help <> nil do
      begin
	if node ^. key > help ^.key then
	begin
	  if help ^. right <> nil then
		help := help ^. right
	  else
          begin
	      help ^. right := node ;
	      break ;
	  end;{ of else}
	end{ of if}
	else
        begin
	    if help ^. left <> nil then
		   help := help ^. left
	    else
            begin
		 help ^. left := node ;
		 break ;
	    end;{ of else}
	end; { of else}
      end;{ of while}
   end; { else}
end;
{**********************}
procedure input (var start : treePtr);
var
   num : integer;
begin
    while true do
    begin
      write('Enter a number:');
      readln(num);
      if num = 0 then
	  break;
      tinsert(start, num);
    end;{end while}
end;
{***********************}
function  menu_select : integer;
var
   choice : integer ;
begin
   writeln('1- Enter a number in tree.');
   writeln('2- Search a number in tree.');
   writeln('3- Print information on screen.') ;
   writeln('4- delete an item.');
   writeln('5- Quit from program.') ;
   write('Enter your select(1-5):');
   readln(choice);
   menu_select := choice;
end;
{**************************}
function  search(s : treePtr; num : integer) : boolean;
var
   h : treePtr;
begin
   h := s;
   search := false;
   while h <> nil do
   begin
      if  num < h ^. key then
	  h := h ^. left
      else if num > h ^.key then
	 h := h ^. right
      else
      begin
         search := true;
         break;
      end;{else}
    end;{of while}
end;
{*************************}
procedure inorder (s : treePtr);
begin
    if s <> nil then
    begin
       inorder(s ^. left) ;
       write(s ^. key, ' ');
       inorder(s ^. right) ;
    end;
end;
{********************}
procedure search2(var root : treePtr; item : integer; var found : boolean;
	     var locptr : treePtr; var parent : treePtr);
begin
   locptr := root;
   parent := nil;
   found := false;
   while true do
   begin
       if (found) or (locptr = nil) then
	  exit;
       if item < locptr ^. key then   {descend left}
       begin
	  parent := locptr;
	  locptr := locptr ^. left;
       end
       else if item > locptr ^. key then  {descend right}
       begin
	  parent := locptr;
	  locptr := locptr ^. right;
       end
       else
	  found := true;
   end;{while}
end;
{******************}
procedure deleteNode(var root : treePtr; item : integer);
var
   found : boolean;
   x, parent, xSucc, subtree : treePtr;
begin
  search2(root, item, found, x, parent);
  if  not found then
  begin
      write('item not found in BST.');
      exit;
  end;
  if (x ^. left <> nil) and (x ^. right <> nil) then
  begin    {node has two children
            Find x's successor and its parent}
       xSucc := x ^. right;
       parent := x;
       while xSucc ^. left <> nil do  {descend left}
       begin
	  parent := xSucc;
	  xSucc := xSucc ^. left;
       end;
       {Move contents of xSucc to x and change x
       to point to successor, wich will be deleted.}
       x ^. key := xSucc ^. key;
       x := xSucc;
  end; {of if}
  {Now proceed with case where node has 0 or 1 child}
  subtree := x ^. left;   {point to a subtree of x}
  if subtree = nil then
     subtree := x ^. right;
  if parent = nil then    {root being deleted}
      root := subtree
  else if parent ^. left = x then {left child of parent}
      parent ^. left := subtree
  else           {right child of parent}
      parent ^. right := subtree;
  dispose(x);
end;{ of deleteNode}
{*************************}
begin
    start := nil;
    while  true do
    begin
	clrscr;
	case menu_select of
	   1:
		 input(start) ;
	   2:
              begin
		 write('Enter number to search:');
		 readln(num);
		 if search(start, num) then
		    write('Number found.')
		 else
		    write('Number not found.');
		 readln ;
	      end;
	  3:
              begin
		 clrscr;
		 writeln('Traverse tree in inorder:');
		 inorder(start) ;
		 readln;
	      end;
	  4:
              begin
		 write('Enter number to delete:');
		 readln(num);
		 deleteNode(start, num);
                 readln;
	      end;
	  5:
		 exit ;
	end;{ of switch}
    end;{ of while}
end.
