procedure search2(var root : treePtr; item : integer; var found : boolean;
	     var locptr : treePtr; var parent : treePtr);
begin
   locptr := root;
   parent := nil;
   found := false;
   while true do
   begin
       if (found) or (locptr = nil) then
	  exit;
       if item < locptr ^. key then   {descend left}
       begin
	  parent := locptr;
	  locptr := locptr ^. left;
       end
       else if item > locptr ^. key then  {descend right}
       begin
	  parent := locptr;
	  locptr := locptr ^. right;
       end
       else
	  found := true;
   end;{while}
end;
{******************}
procedure deleteNode(var root : treePtr; item : integer);
var
   found : boolean;
   x, parent, xSucc, subtree : treePtr;
begin
  search2(root, item, found, x, parent);
  if  not found then
  begin
      write('item not found in BST.');
      exit;
  end;
  if (x ^. left <> nil) and (x ^. right <> nil) then
  begin    {node has two children
            Find x's successor and its parent}
       xSucc := x ^. right;
       parent := x;
       while xSucc ^. left <> nil do  {descend left}
       begin
	  parent := xSucc;
	  xSucc := xSucc ^. left;
       end;
       {Move contents of xSucc to x and change x
       to point to successor, wich will be deleted.}
       x ^. key := xSucc ^. key;
       x := xSucc;
  end; {of if}
  {Now proceed with case where node has 0 or 1 child}
  subtree := x ^. left;   {point to a subtree of x}
  if subtree = nil then
     subtree := x ^. right;
  if parent = nil then    {root being deleted}
      root := subtree
  else if parent ^. left = x then {left child of parent}
      parent ^. left := subtree
  else           {right child of parent}
      parent ^. right := subtree;
  dispose(x);
end;{ of deleteNode}
