program data;
uses crt;
type
    nodePtr = ^node;
    node = record
       time : integer;
       duration : integer;
       kind :integer;
       next : nodePtr;
    end;
type
    queue = record
        front : nodePtr;
        rear  : nodePtr;
        num   : integer;
    end;
var
   q : array[0..3] of queue;
   auxinfo : node;
   evlist : nodePtr;
   atime, dtime, dur, qindex : integer;
   count, tottime : single;
{*************}
procedure qinsert(var q1 : queue;  var auxinfo : node);
  var
     help : nodePtr;
begin
  new(help);
  help^ := auxinfo;
  (q1.num) := (q1.num) + 1 ;
  if q1.front = nil  then
  begin
      q1.front := help;
      q1.rear := help;
  end
  else
  begin
       q1.rear ^. next := help;
       q1.rear := q1.rear ^. next;
  end;
end;
{*******************}
procedure place(var evlist : nodePtr; var auxinfo : node);
  var
     h, p, help : nodePtr;
begin
   new(help);
   help^ := auxinfo;
   if evlist = nil  then
      evlist := help
   else
   begin
       p := evlist;
       h := evlist;
       while h <> nil do
       begin
	     if help^.time > h^.time  then
	     begin
		p := h;
		h := h^.next;
	     end
	     else
		break;
       end;{ of while}
       help^.next := h;
       if h = evlist then
	  evlist := help
       else
	  p^.next := help;
   end;{ of else}
end;
{***********************}
procedure arrive(atime : integer; dur : integer);
  var
    i, j, small : integer;
begin
   {find the shortest queue}
   j := 0;
   small := q[0].num;
   for i := 1 to 3 do
      if q[i].num < small then
      begin
         small := q[i].num;
         j := i;
      end;{of if}
   {queue j is the shorthest,
   insert a new customer node}
   auxinfo.time := atime;
   auxinfo.duration := dur;
   auxinfo.kind := j;
   auxinfo.next := nil;
   qinsert(q[j], auxinfo);
   {check if this is the only node on the queue.
   if it is, the customer's departure node must
   be placed on the event list.}
   if q[j].num = 1 then
   begin
      auxinfo.time := atime + dur;
      place(evlist, auxinfo);
   end;
   {if any input remains, read the next data pair
   and place an arrival on the event list.}
   write('Enter time:');
   readln(auxinfo.time);
   if auxinfo.time <> -1 then
   begin
      write('Enter duration:');
      readln(auxinfo.duration);
      auxinfo.kind := -1;
      auxinfo.next := nil;
      place(evlist, auxinfo);
   end;
end;{end of arrive}
{*************}
procedure qremove(var  q1 : queue; var auxinfo : node);
  var
     p : nodePtr;
begin
    if q1.front <> nil then
    begin
       p := q1.front;
       (q1.num) := (q1.num) - 1;
       auxinfo.time := q1.front ^.time;
       auxinfo.kind := q1.front ^.kind;
       auxinfo.duration := q1.front ^.duration;
       q1.front := q1.front ^. next;
       p ^. next := nil;
       dispose(p);
    end;
end;
{***********************}
procedure depart(qindex : integer; dtime : integer);
   var p : nodePtr;
begin
  qremove(q[qindex], auxinfo);
  tottime := tottime + (dtime - auxinfo.time);
  count := count + 1;
  {if there are any more customers on the queue
  place the departure of the next customer onto
  the event list after computing its departure time}
  if q[qindex].num > 0  then
  begin
    p := q[qindex].front;
    auxinfo.time := dtime + p^.duration;
    auxinfo.kind := qindex;
    auxinfo.next := nil;
    place(evlist, auxinfo);
  end;
end;
{****************}
procedure popsub(var evlist : nodePtr; var auxinfo : node);
begin
    auxinfo.time := evlist^. time;
    auxinfo.kind := evlist^. kind;
    auxinfo.duration := evlist^. duration;
    evlist := evlist^. next;
end;
{***********************}
begin
   evlist := nil;
   count := 0;
   tottime := 0;
   for qindex := 0 to 3 do
   begin
      q[qindex].num := 0;
      q[qindex].front := nil;
      q[qindex].rear  := nil;
   end;{for}
   clrscr;
   write('Enter time and duration:');
   read(auxinfo.time, auxinfo.duration);
   auxinfo.kind := -1;  {an arrive}
   auxinfo.next := nil;
   place(evlist, auxinfo);
   { run the simulation as long as
   the event list is not empty }
   while evlist <> nil do
   begin
      popsub(evlist, auxinfo);
      { check if the next event
       is an arrival or departure}
      if auxinfo.kind = -1 then
      begin
         atime := auxinfo.time;
         dur := auxinfo.duration;
         arrive(atime, dur);
      end {then}
      else
      begin
         {a departure}
         qindex := auxinfo.kind;
         dtime := auxinfo.time;
         depart(qindex, dtime);
      end;{else}
   end;{while}
   write('Average time is :', tottime / count : 5 : 2);
   readln;
end.
