program data;
uses crt;
const SIZE = 5;
type queue = record
         items : array[0..SIZE -1] of integer;
         front : integer;
         rear  : integer;
     end;
var
   q : queue;
   x, overflow, underflow : integer;
{**************************}
function empty(q : queue) : boolean;
begin
   empty := false;
   if q.rear < q.front then
      empty := true;
end; {function}
{**************************}
procedure addQ(var q : queue; x : integer; var overflow : integer);
begin
   if q.rear = SIZE - 1 then
      overflow := 1
   else
   begin
      overflow := 0;
      q.rear := (q.rear) + 1;
      q.items[q.rear] := x;
   end;
end;{procedure}
{**************************}
procedure retrieve(var q : queue; var x : integer; var underflow : integer);
begin
   if empty(q) then
      underflow := 1
   else
   begin
      underflow := 0;
      x := q.items[q.front];
   end;
end;{procedure}
{**************************}
procedure qremove(var q : queue; var x : integer; var underflow : integer);
begin
   if empty(q) then
      underflow := 1
   else
   begin
      underflow := 0;
      x := q.items[q.front];
      q.front := (q.front) + 1;
   end;
end;{procedure}
{**************************}
procedure print(var q : queue);
var
   i : integer;
begin
   if empty(q) then
      write('Queue is empty.');
   for i := q.front to q.rear do
        write(q.items[i] : 5);
   writeln;
   write('Press a key to continue.');
   readln;
end;{procedure}
{**************************}
function menu : integer;
var
  c: integer;
begin
  writeln('1. Print queue.');
  writeln('2. Add to queue.');
  writeln('3. Remove from queue.');
  writeln('4. Retrieve from queue.');
  writeln('5. Exit.');
  write('Enter your select(1-5):');
  read(c);
  menu := c;
end;{function}
{**************************}
begin
   q.front := 0;
   q.rear := -1;
   while true do
   begin
       clrscr;
       case menu of
          1:
             begin
               print(q);
               readln;
             end;
          2:
             begin
                write('Enter a value to enter q:');
                read(x);
                addQ(q, x, overflow);
                if overflow = 1 then
                begin
                   write('Queue is full. Press a key to continue.');
                   readln; readln;
                end;
             end;
          3:
             begin
                qremove(q, x, underflow);
                if underflow = 1 then
                begin
                   write('Queue is empty. Press a key to continue.');
                   readln;
                end;
             end;
          4:
             begin
                retrieve(q, x, underflow);
                if underflow = 1 then
                begin
                   write('Queue is empty. Press a key to continue.');
                   readln;
                end
                else
                begin
                   write('Retrieved value is:', x);
                   readln;
                end;
                readln;
             end;
          5:
            exit;
       end;{case}
   end;{while}
end.


