program data;
  uses crt;
  const M = 21;
  type stack = record
          items : array[0..M-1] of single;
          myTop : integer;
       end;
   var
       postfix : string;
  {*****************************}
  procedure push(var s:stack; x:single);
  begin
      s.myTop := s.myTop + 1;
      s.items[s.myTop] := x;
  end;{procedure}
  {*********************}
  procedure pop(var s:stack; var x:single);
  begin
      x := s.items[s.myTop];
      s.myTop := s.myTop - 1;
  end;{procedure}
  {**********************}
  function isDigit(symbol : char) : boolean;
  begin
     isDigit := false;
     if (symbol >= '0') and (symbol <= '9') then
        isDigit := true;
  end;
  {**********************}
  function operate(symbol : char; operand1 : single; operand2 : single) : single;
  begin
     case symbol of
        '+':
            operate := operand1 + operand2;
         '-':
            operate := operand1 - operand2;
         '*':
            operate := operand1 * operand2;
         '/':
            operate := operand1 / operand2;
     end;
  end;{function}
  {**********************}
  function evaluate(postfix : string) : single;
    var
      value, operand1, operand2 : single;
      symbol : char;
      i : integer;
      s : stack;
      num : single;
  begin
     s.myTop := -1;
     for i := 1 to length(postfix) do
     begin
        symbol := postfix[i];
        if isDigit(symbol) then
        begin
          num := ord(symbol) - 48;
          push(s, num);
        end{if}
        else
        begin
           pop(s, operand2);
           pop(s, operand1);
           value := operate(symbol, operand1, operand2);
           push(s, value);
        end;{else}
     end;
     pop(s, value);
     evaluate := value;
  end;{function}
  {**********************}
begin
   clrscr;
   write('Enter a postfix expression:');
   read(postfix);
   write('Evaluation of expression is :', evaluate(postfix) : 5:2);
   readln;
end.












