program data;
  uses crt;
  const M = 21;
  type stack = record
          items : array[0..M-1] of char;
          myTop : integer;
       end;
   var
       infix, postfix : string;
       i, len : integer;
  {*********************}
  function empty(s : stack):boolean;
  begin
     if s.myTop = -1 then
        empty := true
     else
        empty := false
  end;{function}
  {*********************}
  procedure push(var s:stack; x:char);
  begin
      s.myTop := s.myTop + 1;
      s.items[s.myTop] := x;
  end;{procedure}
  {*********************}
  procedure pop(var s:stack; var x:char);
  begin
      x := s.items[s.myTop];
      s.myTop := s.myTop - 1;
  end;{procedure}
  {*********************}
  procedure popAndTest(var s:stack; var x:char; var underflow:integer);
  begin
     if empty(s) then
        underflow := 1
     else
     begin
        x := s.items[s.myTop];
        s.myTop := s.myTop - 1;
        underflow := 0;
     end;
  end;{procedure}
  {**************}
  procedure topAndTest(var s:stack; var x:char; var underflow:integer);
  begin
     if empty(s) then
        underflow := 1
     else
     begin
        x := s.items[s.myTop];
        underflow := 0;
     end;
  end;{procedure}
  {**************}
  function pred(op1 : char; op2 : char) : boolean;
     var
        op  : array[0..4] of char;
        isp : array[0..4] of integer;
        i, p1, p2 : integer;
  begin
     op[0]  := '(';
     op[1]  := '+';
     op[2]  := '-';
     op[3]  := '*';
     op[4]  := '/';
     isp[0] := 0;
     isp[1] := 12;
     isp[2] := 12;
     isp[3] := 13;
     isp[4] := 13;
     for i := 0 to 4 do
        if op[i] = op1 then
        begin
           p1 := i;
           break;
        end;
     for i := 0 to 4 do
        if op[i] = op2 then
        begin
           p2 := i;
           break;
        end;
     if isp[p1] >= isp[p2] then
        pred := true
     else
        pred := false;
  end;{function}
  {**************}
  function isOperand(symbol : char) : boolean;
  begin
     if (symbol >= '0') and (symbol <= '9') then
         isOperand := true
     else
         isOperand := false;
  end;{function}
  {**************}
  procedure convert(var infix : string; var postfix : string; var len:integer);
  var
    symbol, topSymbol : char;
    underflow, i, j : integer;
    s : stack;
  begin
    j := 1;
    s.myTop := -1;
    for i := 1 to length(infix) do
    begin
       symbol := infix[i];
       if isoperand(symbol) then
       begin
          postfix[j] := symbol;
          j := j + 1;
       end{if}
       else if symbol = '(' then
          push(s, symbol)
       else if symbol = ')' then
       begin
         pop(s, topSymbol);
         while(topSymbol <> '(') do
         begin
              postfix[j] := topSymbol;
              j := j + 1;
              pop(s, topSymbol);
         end;{while}
       end{else if}
       else
       begin
          topAndTest(s, topSymbol, underflow);
          {if op1 > op2 then true}
          if empty(s) or (not pred(topSymbol, symbol)) then
              push(s, symbol)
          else
          begin
             popAndTest(s, topSymbol, underflow);
             while pred(topSymbol, symbol) and (underflow = 0) do
             begin
                postfix[j] := topSymbol;
                j := j + 1;
                popandTest(s, topSymbol, underflow);
             end;{while}
             push(s, symbol);
          end;{else}
       end;{else}
    end;{for}
    while  not empty(s) do
    begin
       pop(s, topSymbol);
       postfix[j] := topSymbol;
       j := j + 1;
    end;{while}
    len := j - 1;
end;{procedure}
{******************}
begin
   clrscr;
   write('Enter an infix expression:');
   readln(infix);
   convert(infix, postfix, len);
   write('Postfix expression is:');
   for i := 1 to len do
      write(postfix[i], ' ');
   readln;
end.


















