﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Collections;

namespace EdgeListImplement
{
    class EdgeListGraph
    {
        ArrayList nodes;
        NodeList start;
        NodeList eofNodeList;
        EdgeList eofEdgeList;
        NodeList current;
        public EdgeListGraph()
        {
            start = null;
            eofEdgeList = null;
            eofNodeList = null;
            current = null;
            nodes = new ArrayList();
        }
        //******************
        public void makeNodesList(string data) //line 25
        {
            NodeList nodeType;     
            nodeType = new NodeList(data);
            if (start == null)
                start = eofNodeList = nodeType;
            else
            {
                eofNodeList.NextNode = nodeType;
                eofNodeList = nodeType;
            }
            nodes.Add(data);       //line 36 
        }//end of makeNodeList     //line 37
        //************************
        public void makeEdgeList(string data)  //line 39
        {
            EdgeList edgeList;                 //line 41
            NodeList target;                   //line 42
            current = start;                   //line 43
            while (current != null)            //line 44
            {
                if ((current.Info).CompareTo(data) == 0)
                    break;
                current = current.NextNode;
            }                                   //line 49
            string num, item;                   //line 50
            eofEdgeList = null;                 //line 51
            while (true)                        //line 52
            {
                Console.WriteLine("Enter adjacy list for  node " +
                                             data + " : ");
                num = Console.ReadLine();       //line 56
                if (num.CompareTo("-1") == 0)   //line 57
                    break;
                edgeList = new EdgeList();      //line 59
                if (eofEdgeList == null)        //line 60
                {
                    current.EdgeRef = edgeList;
                    eofEdgeList = edgeList;
                }                               //line 64
                else                            //line 65
                {
                    eofEdgeList.NextArc = edgeList;
                    eofEdgeList = edgeList;
                }//end of else                   //line 69
                //find the target node 
                item = (string)nodes[Convert.ToInt16(num)];   //line 71
                target = start;                               //line 72 
                while (target != null)                        //line 73
                {
                    if ((target.Info).CompareTo(item) == 0)   //line 75
                        break;
                    target = target.NextNode;
                }                                             //line 78
                eofEdgeList.NodeRef = target;                 //line 79
            }//end of outer while                               line 80
        }//end of makeEdgeList                                //line 81
        //**********************
        public void showEdgeGraph()            //line 83
        {
            NodeList currentNode = new NodeList(); //line 85
            EdgeList currentEdge = new EdgeList(); //line 86
            currentNode = start;                   //line 87
            while (currentNode != null)            //line 88
            {
                Console.Write("Node  " + currentNode.Info + " -> ");
                currentEdge = currentNode.EdgeRef;
                while (currentEdge != null)        //line 92
                {
                    Console.Write((currentEdge.NodeRef).Info + "  ");
                    currentEdge = currentEdge.NextArc;
                }                                   //line 96
                currentNode = currentNode.NextNode; //line 97
                Console.WriteLine();
            }                                    //line 99
        }//end of showEdgeGraph                  //line 100
    }//end of class EdgeListGraph
}
