﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace TreeExample
{
    class BinSearchTree
    {
        public TreeNode root;                //line 10
        public BinSearchTree()               //line 11
        {
            root = null;
        }                                    //line 14
        //*******************
        public void Insert(int  item)        //line 16
        {
            TreeNode newNode = new TreeNode(item);
            TreeNode currnt = root;
            if (root == null)               //line 20
                root = newNode;
            else                            //line 22
            {
                while ( true )              //line 24
                {
                    if (newNode.Data > currnt.Data)   //line 26
                    {
                        if (currnt.Right != null) //go right
                            currnt = currnt.Right;
                        else //insert right
                        {
                            currnt.Right = newNode ;
                            break;
                        }//end of else
                    }//end of if                     //line 35
                    else                             //line 36
                    {
                        if (currnt .Left != null )//go left
                            currnt = currnt .Left ;
                        else //insert left
                        {
                            currnt .Left = newNode ;
                            break ;
                        }//end of else
                    }//end of else;                 //line 45
                }//end of while                     //line 46
            }//end of else
        }//end of Insert                             //line 48 
        //********************
        public void InOrder(TreeNode theRoot)        //line 50
        {
            if (!(theRoot == null))
            {
                InOrder(theRoot.Left);
                theRoot.DisplayNode();
                InOrder(theRoot.Right);
            }//end of if
        }//end of InOrder                           //line 58
        //********************
        public void PostOrder(TreeNode theRoot)     //line 60
        {
            if (!(theRoot == null))
            {
                PostOrder(theRoot.Left);
                PostOrder(theRoot.Right);
                theRoot.DisplayNode();
            }
        }//end of PostOrde                          //line 68
        //********************
        public void PreOrder(TreeNode theRoot)      //line 70
        {
            if (!(theRoot == null))
            {
                theRoot.DisplayNode();
                PreOrder(theRoot.Left);
                PreOrder(theRoot.Right);
            }
        }//end of PreOrder                          //line 78
        //**********************
        public TreeNode Find(int key)               //line 80
        {
            TreeNode current = root;               //line 81
            while (current.Data != key)            //line 82
            {
                if (key < current.Data)  //go left           
                    current = current.Left;
                else                     //go right
                current = current.Right;   
                if (current == null)
                    return null;
            }
            return current;
        }//end of Find                             //line 93
        //***********************
        public int FindMax()                       //line 95
        {
            TreeNode current = root;
            while (!(current.Right == null))      //line 98
                current = current.Right;
            return current.Data;
        }//end of FindMax                         //line 101
        //**********************
        public int FindMin()                      //line 103
        {
            TreeNode current = root;
            while (!(current.Left == null))       //line 106
                current = current.Left;
            return current.Data;
        }//end of FindMin                         //line 109
        //********************
        public void DeleteNode(int item)          //line 111
        {
            TreeNode x = new TreeNode();          //line 112
            TreeNode parent = new TreeNode();
            TreeNode xSucc = new TreeNode();
            TreeNode subtree = new TreeNode();    //line 115
            x = root;                             //line 116
            //find x to delete
            bool found = false;                   //line 118
            while (!found && x != null)           //line 119
            {
                if (item < x.Data) //go left descend //line 121
                {  
                    parent = x;
                    x = x.Left;
                }
                else if (item > x.Data) //go reight descend
                {
                    parent = x;
                    x = x.Right;
                }
                else       //x found
                {
                    found = true;
                }
            }//end of while                     //line 135
            if (x == null)                      //line 136
            {
                Console.WriteLine("Item not found in BST.");
                return;
            }                                   //line 140
            else                                //line 141
                Console.WriteLine("\nkey  " + item + " is deleted : ");

            if (x.Left != null && x.Right != null) //line 144
            {
                //node x has two children
                //Find x's successor and its parent
                xSucc = x.Right;                 //line 148
                parent = x;                      //line 149
                while (xSucc.Left != null) //left descend line 150
                {
                    parent = xSucc;
                    xSucc = xSucc.Left;
                }//end of while                           //line 154
                //move contents of xSucc to x 
                //and change x to point to successor which will be deleted
                x.Data = xSucc.Data;                     //line 157
                x = xSucc;                               //line 158
            }//end of if                              //159
            //now proceed with case where node has 0 or 1 child
            subtree = x.Left; //point to subtree of x;  line 160
            if (subtree == null)                      //line 161
                subtree = x.Right;
            if (parent == null) //root being deleted   line 163
                root = subtree;
            else if (parent.Left == x)               //line 165
                parent.Left = subtree;
            else  //right child of parent            //line 167
                parent.Right = subtree;
        }//end of DeleteNode                         //line 169
    }//end of BinSearcTree                           //line 170
}
