﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace GenericLinkedList
{
    class Program
    {
        static void Main(string[] args)
        {
            string[] colors = { "black",   //line   12
                             "yellow", "green", "blue", "silver" };
            LinkedList<string> colorList = new LinkedList<string>();  //line 14
            foreach (string color in colors)                          //line 15
                colorList.AddLast(color);

            Console.WriteLine("Forward print :");                     //line 18 
            printList(colorList);                                 //line 19
            Console.WriteLine();

            LinkedListNode<string> colorNode = colorList.First;       //line 22
            colorList.AddAfter(colorNode, "red");                     //line 23

            colorList.AddAfter(colorList.Find("blue"), "magenta");    //line 25

            Console.WriteLine("Forward print :");                     //line 27
            printList(colorList);                                 //line 28

            removeNodes(colorList, "yellow", "magenta");             //line 30

            Console.WriteLine();
            Console.WriteLine("Forward print :");                     //line 33
            printList(colorList);                                 //line 34

            Console.WriteLine();
            Console.WriteLine("Backward print :");                    //line 37
            printReverse(colorList);                                  //line 38
            Console.Read();
        }//end of Main
        private static void printList<T>(LinkedList<T> list)      //line 42
        {
            foreach (T item in list)                                  //line 44
                Console.Write("{0}  ", item);
            Console.WriteLine();
        }//end of printList                                           //line 47
        //*****************
        private static void printReverse<T>(LinkedList<T> list)       //line 49
        {
            LinkedListNode<T> currentNode = list.Last;
            while (currentNode != null)
            {
                Console.Write("{0}  ", currentNode.Value);
                currentNode = currentNode.Previous;  //get previous node
            }//end while
            Console.WriteLine();
        }//end of printRevers                                         //line 58
        //*******************                                         //line 59
        private static void removeNodes<T>(LinkedList<T> list, T startItem, T endItem)
        {
            LinkedListNode<T> curNode = list.Find(startItem);
            LinkedListNode<T> endNode = list.Find(endItem);
            while ((curNode.Next != null) && (curNode.Next != endNode))
            {
                list.Remove(curNode.Next);   //remove next node
            }
        }//end of method removeNodeBetween                            //line 68
    }
}
