﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace DoubleLinked
{
    class DLinkedList
    {
        protected DNode header;
        public DLinkedList()
        {
            header = new DNode("0");
        }
        //**********************
        public void Insert(Object newItem, Object after)
        {
            DNode current = new DNode();
            DNode newNode = new DNode(newItem);
            current = Find(after);
            //if current is not end of list
            if (current .Flink != null )
                    current.Flink.Blink = newNode;
            newNode.Flink = current.Flink;
            newNode.Blink = current;
            current.Flink = newNode;
            //add the count of nodes
            header.Data = (Object)(Convert.ToInt32(header.Data) + 1);
        }
        //************************
        private DNode Find(Object item)
        {
            DNode current = new DNode();
            current = header;
            while (current.Data != item)
                current = current.Flink;
            return current;
        }//end of Find
        //***********************
        public void Remove(Object n)
        {
            DNode p = Find(n);
            if (!(p.Flink == null))
            {
                p.Blink.Flink = p.Flink;
                p.Flink.Blink = p.Blink;
                p.Flink = null;
                p.Blink = null;
                //decrease the count of nodes
                header.Data = (Object)(Convert.ToInt32(header.Data) - 1);
            }
        }
        //*********************
        private DNode FindLast()
        {
            DNode current = new DNode();
            current = header;
            while (!(current.Flink == null))
                current = current.Flink;
            return current;
        }
        //*******************
        public void PrintReverse()
        {
            DNode current = new DNode();
            current = FindLast();
            while (!(current.Blink == null))
            {
                Console.Write("{0} {1}", current.Data, " ");
                current = current.Blink;
            }
            Console.WriteLine("\nCount  = " + header.Data);
        }
        //**********************
        public void PrintList()
        {
            DNode current = new DNode();
            current = header;
            while (!(current.Flink == null))
            {
                Console.Write("{0} {1}", current.Flink.Data, " ");
                current = current.Flink;
            }
            Console.WriteLine("\nCount  = " + header.Data);
        }//end of PrintList
    }
}
