﻿Imports System.Web.UI.WebControls.WebParts
Partial Class _Default
    Inherits System.Web.UI.Page

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        If Not Me.IsPostBack Then
            Dim i As Integer = 1
            For Each part As WebPart In MyPartManager.WebParts
                If TypeOf part Is GenericWebPart Then
                    part.Title = String.Format("Web Part Nr. {0}", i)
                    i += 1
                End If
            Next
        End If

        If Not Me.IsPostBack Then
            Dim Root As MenuItem = New MenuItem("Select Modes")
            For Each mode As WebPartDisplayMode In MyPartManager.DisplayModes
                If mode.IsEnabled(MyPartManager) Then
                    Root.ChildItems.Add(New MenuItem(mode.Name))
                End If
            Next
            PartsMenu.Items.Add(Root)
        End If

    End Sub

    Protected Sub PartsMenu_MenuItemClick(ByVal sender As Object, ByVal e As System.Web.UI.WebControls.MenuEventArgs) Handles PartsMenu.MenuItemClick
        For Each mode As WebPartDisplayMode In MyPartManager.DisplayModes
            If mode.Name.Equals(e.Item.Text) Then
                MyPartManager.DisplayMode = mode
            End If
        Next
    End Sub

    Protected Sub MyCalendar_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles MyCalendar.Load
        Dim part As GenericWebPart = DirectCast(MyCalendar.Parent, GenericWebPart)
        part.AllowClose = False
        part.HelpMode = WebPartHelpMode.Modeless
        part.HelpUrl = "CalendarHelp.htm"
    End Sub
End Class
