﻿Imports rayaneh.commerce
Imports System.Data.SqlClient
Imports System.Data
Partial Class checout
    Inherits System.Web.UI.Page

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        If Not Page.IsPostBack Then
            If Profile.Cart Is Nothing Then
                NoCartlabel.Visible = True
                Wizard1.Visible = False
            End If
            If User.Identity.IsAuthenticated Then
                Wizard1.ActiveStepIndex = 1
            Else
                Wizard1.ActiveStepIndex = 0
            End If
        End If
    End Sub

    Protected Sub chkUseProfileAddress_CheckedChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles chkUseProfileAddress.CheckedChanged
        txtName.Text = Profile.Name
        txtAddress.Text = Profile.Address
        txtCity.Text = Profile.City
        txtCounty.Text = Profile.County
        txtPostCode.Text = Profile.PostCode
        txtCountry.Text = Profile.Country
    End Sub

    Protected Sub Wizard1_FinishButtonClick(ByVal sender As Object, ByVal e As System.Web.UI.WebControls.WizardNavigationEventArgs) Handles Wizard1.FinishButtonClick
        Dim trans As SqlTransaction = Nothing
        Dim cmd As SqlCommand
        Dim strCon As String
        strCon = " Data Source=GHOMI-PC;Initial Catalog=product;Integrated Security=True"
        Dim conn As SqlConnection
        conn = New SqlConnection(strCon)
        Try
            conn.Open()
            trans = conn.BeginTransaction()
            cmd = New SqlCommand()
            cmd.Connection = conn
            cmd.Transaction = trans
            'set the order details
            Dim strSql As String
            strSql = "insert into orders(MemberName, OrderDate, Name, Address, County, PostCode, Country, Total)"
            strSql += "Values(@MemberName, @OrderDate, @OrderDate, @Name, @Address, @County, @PostCode, @Total)"
            strSql += "select cast(scope_identity() As int)"
            cmd.CommandText = strSql

            cmd.Parameters.Add("@MemberName", SqlDbType.VarChar, 50)
            cmd.Parameters.Add("@OrderDate", SqlDbType.DateTime)
            cmd.Parameters.Add("@Name", SqlDbType.VarChar, 50)
            cmd.Parameters.Add("@Address", SqlDbType.VarChar, 255)
            cmd.Parameters.Add("@County", SqlDbType.VarChar, 50)
            cmd.Parameters.Add("@PostCode", SqlDbType.VarChar, 15)
            cmd.Parameters.Add("@Country", SqlDbType.VarChar, 50)
            cmd.Parameters.Add("@Total", SqlDbType.Money)

            cmd.Parameters("@MemberName").Value = User.Identity.Name
            cmd.Parameters("@OrderDate").Value = DateTime.Now
            cmd.Parameters("@Name").Value = CType(Wizard1.FindControl("txtName"), TextBox).Text
            cmd.Parameters("@Address").Value = CType(Wizard1.FindControl("txtAddress"), TextBox).Text
            cmd.Parameters("@County").Value = CType(Wizard1.FindControl("txtCounty"), TextBox).Text
            cmd.Parameters("@PostCode").Value = CType(Wizard1.FindControl("txtPostCode"), TextBox).Text
            cmd.Parameters("@Country").Value = CType(Wizard1.FindControl("txtCountry"), TextBox).Text
            cmd.Parameters("@Total").Value = Profile.Cart.Total

            Dim OrderId As Integer = Convert.ToInt32(cmd.ExecuteScalar())
            ' change the query and parameters for the order lines
            strSql = "INSERT INTO orderLines(orderID, isbn, quantity, price) "
            strSql += "VALUES (@OrderID, @isbn, @quantity, @price)"
            cmd.CommandText = strSql
            cmd.Parameters.Clear()
            cmd.Parameters.Add("@orderID", SqlDbType.Int)
            cmd.Parameters.Add("@isbn", SqlDbType.Text)
            cmd.Parameters.Add("@quantity", SqlDbType.Int)
            cmd.Parameters.Add("@price", SqlDbType.Money)

            cmd.Parameters("@orderID").Value = OrderId

            For Each item As CartItem In Profile.Cart.Items

                cmd.Parameters("@isbn").Value = item.Isbn
                cmd.Parameters("@quantity").Value = item.Quantity
                cmd.Parameters("@price").Value = item.Price
                cmd.ExecuteNonQuery()

            Next
            ' commit the transaction
            trans.Commit()
        Catch SqlEx As SqlException
            ' some form of error - rollback the transaction 
            ' and rethrow the exception
            If trans IsNot Nothing Then
                trans.Rollback()
            End If
            ' Log the exception
            ' Tools.log("An error occurred while creating the order", SqlEx)
            Throw

        Finally
            conn.Close()
        End Try
        ' we will only reach here if the order has been created sucessfully
        ' so clear the cart
        Profile.Cart.Items.Clear()
    End Sub

    Protected Sub Wizard1_NextButtonClick(ByVal sender As Object, ByVal e As System.Web.UI.WebControls.WizardNavigationEventArgs) Handles Wizard1.NextButtonClick
        If e.CurrentStepIndex = 0 Then
            Dim l As System.Web.UI.WebControls.Login = CType(Wizard1.FindControl("Login1"), Login)
            If Membership.ValidateUser(l.UserName, l.Password) Then
                FormsAuthentication.SetAuthCookie(l.UserName, l.RememberMeSet)
                e.Cancel = False
            Else
                l.InstructionText = "Your login attempt was not successful. Please try again."
                l.InstructionTextStyle.ForeColor = System.Drawing.Color.Red
                e.Cancel = True
            End If
        Else
            If Not User.Identity.IsAuthenticated Then
                e.Cancel = True
                Wizard1.ActiveStepIndex = 0
            End If
        End If
    End Sub

    Protected Sub Wizard1_ActiveStepChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles Wizard1.ActiveStepChanged
        If Not User.Identity.IsAuthenticated Then
            Wizard1.ActiveStepIndex = 0
        End If
    End Sub
End Class
