﻿Imports Microsoft.VisualBasic
Imports System.Data
Imports System.Data.SqlClient
Imports System.Collections.Generic
Namespace rayaneh.commerce
    <Serializable()>
    Public Class CartItem
        Private _isbn As String
        Private _title As String
        Private _picUrl As String
        Private _quantity As Integer
        Private _price As Integer
        Private _lineTotal As Integer
        Public Sub New()

        End Sub
        '*****************************
        Public Sub New(ByVal isbn As String, ByVal title As String, ByVal picUrl As String, ByVal quantity As Integer, ByVal price As Integer)
            _isbn = isbn
            _title = title
            _picUrl = picUrl
            _quantity = quantity
            _price = price
            _lineTotal = quantity * price
        End Sub
        '**************************
        Public Property Isbn() As String
            Get
                Return _isbn
            End Get
            Set(ByVal value As String)
                _isbn = value
            End Set
        End Property
        '**********************
        Public Property Title() As String
            Get
                Return _title
            End Get
            Set(ByVal value As String)
                _title = value
            End Set
        End Property
        '***********************
        Public Property PicUrl() As String
            Get
                Return _picUrl
            End Get
            Set(ByVal value As String)
                _picUrl = value
            End Set
        End Property
        '********************
        Public Property Quantity() As Integer
            Get
                Return _quantity
            End Get
            Set(ByVal value As Integer)
                _quantity = value
            End Set
        End Property
        '********************
        Public Property Price() As Integer
            Get
                Return _price
            End Get
            Set(ByVal value As Integer)
                _price = value
            End Set
        End Property
        '*******************
        Public Property LineTotal() As Integer
            Get
                Return _quantity * _price
            End Get
            Set(ByVal value As Integer)

            End Set
        End Property
        '******************
    End Class
    '****************
    <Serializable()>
    Public Class ShoppingCart
        Private _dateCreated As Date
        Private _lastUpdate As Date
        Private _items As List(Of CartItem)
        Public Sub New()
            _items = New List(Of CartItem)
            _dateCreated = Date.Today
        End Sub
        '************
        Public Property Items() As List(Of CartItem)
            Get
                Return _items
            End Get
            Set(ByVal value As List(Of CartItem))
                _items = value
            End Set
        End Property
        '******************

        Private Function ItemIndexOfID(ByVal isbn As String) As Integer
            Dim index As Integer
            For Each item As CartItem In _items
                If item.Isbn = isbn Then
                    Return index
                End If
                index += 1
            Next
            Return -1
        End Function
        '**************************
        Public Sub insert(ByVal isbn As String, ByVal price As Integer, ByVal quantity As Integer, ByVal title As String, ByVal picUrl As String)
            Dim itemindex As Integer = ItemIndexOfID(isbn)
            If itemindex = -1 Then
                Dim newitem As New CartItem()
                newitem.Isbn = isbn
                newitem.Quantity = quantity
                newitem.Price = price
                newitem.Title = title
                newitem.PicUrl = picUrl
                _items.Add(newitem)
            Else
                _items(itemindex).Quantity += 1
                _lastUpdate = Date.Today
            End If
        End Sub
        '********************
        Public Sub update(ByVal RowID As Integer, ByVal isbn As Integer, ByVal quantity As Integer, ByVal price As Integer)
            Dim item As CartItem = _items(RowID)
            item.Isbn = isbn
            item.Quantity = quantity
            item.Price = price
            _lastUpdate = Date.Today
        End Sub
        '***********************
        Public Sub deleteitem(ByVal RowID As Integer)

            _items.RemoveAt(RowID)
            _lastUpdate = Date.Today
        End Sub
        '*********************
        Public ReadOnly Property Total() As Integer
            Get
                Dim t As Integer = 0
                If _items Is Nothing Then
                    Return 0
                End If
                For Each item As CartItem In _items
                    t += item.LineTotal
                Next
                Return t
            End Get
        End Property
    End Class
End Namespace

