﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Collections;

namespace GraphTraversal
{
    class MatGraph
    {
        private const int NUM_VERTICES = 20; //line 11
        private MatVertex[] vertices;        //line 12
        private int[,] adjMatrix;            //line 13
        int numVerts;                        //line 14
        public MatGraph()                    //line 15
        {
            vertices = new MatVertex[NUM_VERTICES]; //line 16
            adjMatrix = new int[NUM_VERTICES, NUM_VERTICES]; //line 17
            numVerts = 0;
            for (int i = 0; i < NUM_VERTICES; i++)           //line 19
                for (int j = 0; j < NUM_VERTICES - 1; j++)   //line 20
                    adjMatrix[i, j] = 0;
        }                                                    //line 22
        //*********************
        public void AddVertex(string label)                  //line 24
        {
            vertices[numVerts] = new MatVertex(label);
            numVerts++;
        }                                                   //line 28
        //*****************
        public void AddEdge(int start, int eend)            //line 30
        {
            adjMatrix[start, eend] = 1;
            // adjMatrix[eend, start] = 1;                  //line 33
        }                                                   //line 34
        //*******************
        public void ShowAllVertex()                         //line 36
        {
            for (int i = 0; i < numVerts; i++)
                Console.Write("{0}  ", vertices[i].Label);
        }                                                   //line 40
        //******************
        public void ShowVertex(int v)                       //line 42
        {
            Console.Write(vertices[v].Label + " ");
        }                                                  //line 45
        //*******************
        public void ShowGraph()                            //line 47
        {
            for (int i = 0; i < numVerts; i++)
            {
                for (int j = 0; j < numVerts; j++)
                    Console.Write("{0} ", adjMatrix[i, j]);
                Console.WriteLine();
            }
        } //end of ShowGraph                             //line 55
        //**************************
        public void DepthFirstSearch()                   //line 57
        {
            Stack gStack = new Stack();                  //line 58
            vertices[0].WasVisited = true;               //line 59
            ShowVertex(0);                               //line 60
            gStack.Push(0);                              //line 61
            int v;                                       //line 62
            while (gStack.Count > 0)                     //line 63
            {                                            //line 64
                v = GetAdjUnvisitedVertex((int)gStack.Peek());
                if (v == -1)                             //line 66
                    gStack.Pop();
                else                                     //line 68
                {
                    vertices[v].WasVisited = true;
                    ShowVertex(v);
                    gStack.Push(v);
                }//end of else                        //line 73
            }//end of while                           //line 74
            for (int i = 0; i < numVerts; i++)        //line 75
                vertices[i].WasVisited = false;
        }  //end of DepthFirstSearch                  //line 77
        //*****************************               
        public int GetAdjUnvisitedVertex(int v)        //line 78
        {
            for (int j = 0; j <= NUM_VERTICES - 1; j++) //line 80
            {
                if ((adjMatrix[v, j] == 1) &&           //line 82
                           ((vertices[j].WasVisited) == false))
                    return j;                          //line 84
            }
            return -1;                                 //line 86
        }                                              //line 87
        //*******************
        public void BreadthFirstSearch()               //line 89
        {
            Queue gQueue = new Queue();               //line 91
            vertices[0].WasVisited = true;            //line 92
            ShowVertex(0);                            //line 93
            gQueue.Enqueue(0);                        //line 94
            int vert1, vert2;                         //line 95
            while (gQueue.Count > 0)                  //line 96
            {
                vert1 = (int)gQueue.Dequeue();        //line 98
                vert2 = GetAdjUnvisitedVertex(vert1); //line 99
                while (vert2 != -1)                   //line 100
                {
                    vertices[vert2].WasVisited = true; //line 102
                    ShowVertex(vert2);                 //line 103
                    gQueue.Enqueue(vert2);             //line 104
                    vert2 = GetAdjUnvisitedVertex(vert1); //line 105
                }                                     //line 106
            }                                         //line 107
            for (int i = 0; i < numVerts; i++)        //line 108
                vertices[i].WasVisited = false;
        }//end of BreadthfirstSearch                  //line 110
    }//end of MatGraph                                //line 111 
}
