﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace IteratorClass
{
    class IteratorList
    {
        private Node current;
        private Node previous;
        NewLinkedList theList;
        public IteratorList(NewLinkedList list)
        {
            theList = list;
            current = theList.GetFirst();
            previous = null;
        }
        //*******************
        public void NextLink()
        {
            previous = current;
            current = current.Link;
        }
        //***************
        public Node GetCurrent()
        {
            return current;
        }
        //****************
        public void InsertBefore(Object theElement)
        {
            Node newNode = new Node(theElement);
            if (current == theList.GetFirst())//header)
                throw new InsertBeforeHeaderException("Can't " +
                                  "insert before the header node.");
            else
            {
                newNode.Link = previous.Link;
                previous.Link = newNode;
                current = newNode;
            }
        }
        //****************
        public void InsertAfter(Object theElement)
        {
            Node newNode = new Node(theElement);
            newNode.Link = current.Link;
            current.Link = newNode;
            NextLink();
        }
        //*******************
        public void Remove()
        {
            previous.Link = current.Link;
        }
        //*****************
        public void Reset()
        {
            current = theList.GetFirst();
            previous = null;
        }
        //*****************
        public bool AtEnd()
        {
            return (current.Link == null);
        }
    }
}
